/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.EntityNameListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.String255ListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveDraftAppVersionResourceMappingsRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, RemoveDraftAppVersionResourceMappingsRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(RemoveDraftAppVersionResourceMappingsRequest.getter(RemoveDraftAppVersionResourceMappingsRequest::appArn)).setter(RemoveDraftAppVersionResourceMappingsRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<String>> APP_REGISTRY_APP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appRegistryAppNames").getter(RemoveDraftAppVersionResourceMappingsRequest.getter(RemoveDraftAppVersionResourceMappingsRequest::appRegistryAppNames)).setter(RemoveDraftAppVersionResourceMappingsRequest.setter(Builder::appRegistryAppNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appRegistryAppNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EKS_SOURCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eksSourceNames").getter(RemoveDraftAppVersionResourceMappingsRequest.getter(RemoveDraftAppVersionResourceMappingsRequest::eksSourceNames)).setter(RemoveDraftAppVersionResourceMappingsRequest.setter(Builder::eksSourceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSourceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOGICAL_STACK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logicalStackNames").getter(RemoveDraftAppVersionResourceMappingsRequest.getter(RemoveDraftAppVersionResourceMappingsRequest::logicalStackNames)).setter(RemoveDraftAppVersionResourceMappingsRequest.setter(Builder::logicalStackNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceGroupNames").getter(RemoveDraftAppVersionResourceMappingsRequest.getter(RemoveDraftAppVersionResourceMappingsRequest::resourceGroupNames)).setter(RemoveDraftAppVersionResourceMappingsRequest.setter(Builder::resourceGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceNames").getter(RemoveDraftAppVersionResourceMappingsRequest.getter(RemoveDraftAppVersionResourceMappingsRequest::resourceNames)).setter(RemoveDraftAppVersionResourceMappingsRequest.setter(Builder::resourceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TERRAFORM_SOURCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("terraformSourceNames").getter(RemoveDraftAppVersionResourceMappingsRequest.getter(RemoveDraftAppVersionResourceMappingsRequest::terraformSourceNames)).setter(RemoveDraftAppVersionResourceMappingsRequest.setter(Builder::terraformSourceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSourceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_REGISTRY_APP_NAMES_FIELD, EKS_SOURCE_NAMES_FIELD, LOGICAL_STACK_NAMES_FIELD, RESOURCE_GROUP_NAMES_FIELD, RESOURCE_NAMES_FIELD, TERRAFORM_SOURCE_NAMES_FIELD));
    private final String appArn;
    private final List<String> appRegistryAppNames;
    private final List<String> eksSourceNames;
    private final List<String> logicalStackNames;
    private final List<String> resourceGroupNames;
    private final List<String> resourceNames;
    private final List<String> terraformSourceNames;

    private RemoveDraftAppVersionResourceMappingsRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appRegistryAppNames = builder.appRegistryAppNames;
        this.eksSourceNames = builder.eksSourceNames;
        this.logicalStackNames = builder.logicalStackNames;
        this.resourceGroupNames = builder.resourceGroupNames;
        this.resourceNames = builder.resourceNames;
        this.terraformSourceNames = builder.terraformSourceNames;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasAppRegistryAppNames() {
        return this.appRegistryAppNames != null && !(this.appRegistryAppNames instanceof SdkAutoConstructList);
    }

    public final List<String> appRegistryAppNames() {
        return this.appRegistryAppNames;
    }

    public final boolean hasEksSourceNames() {
        return this.eksSourceNames != null && !(this.eksSourceNames instanceof SdkAutoConstructList);
    }

    public final List<String> eksSourceNames() {
        return this.eksSourceNames;
    }

    public final boolean hasLogicalStackNames() {
        return this.logicalStackNames != null && !(this.logicalStackNames instanceof SdkAutoConstructList);
    }

    public final List<String> logicalStackNames() {
        return this.logicalStackNames;
    }

    public final boolean hasResourceGroupNames() {
        return this.resourceGroupNames != null && !(this.resourceGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> resourceGroupNames() {
        return this.resourceGroupNames;
    }

    public final boolean hasResourceNames() {
        return this.resourceNames != null && !(this.resourceNames instanceof SdkAutoConstructList);
    }

    public final List<String> resourceNames() {
        return this.resourceNames;
    }

    public final boolean hasTerraformSourceNames() {
        return this.terraformSourceNames != null && !(this.terraformSourceNames instanceof SdkAutoConstructList);
    }

    public final List<String> terraformSourceNames() {
        return this.terraformSourceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppRegistryAppNames() ? this.appRegistryAppNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEksSourceNames() ? this.eksSourceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalStackNames() ? this.logicalStackNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceGroupNames() ? this.resourceGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceNames() ? this.resourceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerraformSourceNames() ? this.terraformSourceNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveDraftAppVersionResourceMappingsRequest)) {
            return false;
        }
        RemoveDraftAppVersionResourceMappingsRequest other = (RemoveDraftAppVersionResourceMappingsRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && this.hasAppRegistryAppNames() == other.hasAppRegistryAppNames() && Objects.equals(this.appRegistryAppNames(), other.appRegistryAppNames()) && this.hasEksSourceNames() == other.hasEksSourceNames() && Objects.equals(this.eksSourceNames(), other.eksSourceNames()) && this.hasLogicalStackNames() == other.hasLogicalStackNames() && Objects.equals(this.logicalStackNames(), other.logicalStackNames()) && this.hasResourceGroupNames() == other.hasResourceGroupNames() && Objects.equals(this.resourceGroupNames(), other.resourceGroupNames()) && this.hasResourceNames() == other.hasResourceNames() && Objects.equals(this.resourceNames(), other.resourceNames()) && this.hasTerraformSourceNames() == other.hasTerraformSourceNames() && Objects.equals(this.terraformSourceNames(), other.terraformSourceNames());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveDraftAppVersionResourceMappingsRequest").add("AppArn", (Object)this.appArn()).add("AppRegistryAppNames", this.hasAppRegistryAppNames() ? this.appRegistryAppNames() : null).add("EksSourceNames", this.hasEksSourceNames() ? this.eksSourceNames() : null).add("LogicalStackNames", this.hasLogicalStackNames() ? this.logicalStackNames() : null).add("ResourceGroupNames", this.hasResourceGroupNames() ? this.resourceGroupNames() : null).add("ResourceNames", this.hasResourceNames() ? this.resourceNames() : null).add("TerraformSourceNames", this.hasTerraformSourceNames() ? this.terraformSourceNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appRegistryAppNames": {
                return Optional.ofNullable(clazz.cast(this.appRegistryAppNames()));
            }
            case "eksSourceNames": {
                return Optional.ofNullable(clazz.cast(this.eksSourceNames()));
            }
            case "logicalStackNames": {
                return Optional.ofNullable(clazz.cast(this.logicalStackNames()));
            }
            case "resourceGroupNames": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupNames()));
            }
            case "resourceNames": {
                return Optional.ofNullable(clazz.cast(this.resourceNames()));
            }
            case "terraformSourceNames": {
                return Optional.ofNullable(clazz.cast(this.terraformSourceNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveDraftAppVersionResourceMappingsRequest, T> g) {
        return obj -> g.apply((RemoveDraftAppVersionResourceMappingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private List<String> appRegistryAppNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> eksSourceNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> logicalStackNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> terraformSourceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveDraftAppVersionResourceMappingsRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.appRegistryAppNames(model.appRegistryAppNames);
            this.eksSourceNames(model.eksSourceNames);
            this.logicalStackNames(model.logicalStackNames);
            this.resourceGroupNames(model.resourceGroupNames);
            this.resourceNames(model.resourceNames);
            this.terraformSourceNames(model.terraformSourceNames);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final Collection<String> getAppRegistryAppNames() {
            if (this.appRegistryAppNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appRegistryAppNames;
        }

        public final void setAppRegistryAppNames(Collection<String> appRegistryAppNames) {
            this.appRegistryAppNames = EntityNameListCopier.copy(appRegistryAppNames);
        }

        @Override
        public final Builder appRegistryAppNames(Collection<String> appRegistryAppNames) {
            this.appRegistryAppNames = EntityNameListCopier.copy(appRegistryAppNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appRegistryAppNames(String ... appRegistryAppNames) {
            this.appRegistryAppNames(Arrays.asList(appRegistryAppNames));
            return this;
        }

        public final Collection<String> getEksSourceNames() {
            if (this.eksSourceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eksSourceNames;
        }

        public final void setEksSourceNames(Collection<String> eksSourceNames) {
            this.eksSourceNames = String255ListCopier.copy(eksSourceNames);
        }

        @Override
        public final Builder eksSourceNames(Collection<String> eksSourceNames) {
            this.eksSourceNames = String255ListCopier.copy(eksSourceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksSourceNames(String ... eksSourceNames) {
            this.eksSourceNames(Arrays.asList(eksSourceNames));
            return this;
        }

        public final Collection<String> getLogicalStackNames() {
            if (this.logicalStackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logicalStackNames;
        }

        public final void setLogicalStackNames(Collection<String> logicalStackNames) {
            this.logicalStackNames = String255ListCopier.copy(logicalStackNames);
        }

        @Override
        public final Builder logicalStackNames(Collection<String> logicalStackNames) {
            this.logicalStackNames = String255ListCopier.copy(logicalStackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logicalStackNames(String ... logicalStackNames) {
            this.logicalStackNames(Arrays.asList(logicalStackNames));
            return this;
        }

        public final Collection<String> getResourceGroupNames() {
            if (this.resourceGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceGroupNames;
        }

        public final void setResourceGroupNames(Collection<String> resourceGroupNames) {
            this.resourceGroupNames = EntityNameListCopier.copy(resourceGroupNames);
        }

        @Override
        public final Builder resourceGroupNames(Collection<String> resourceGroupNames) {
            this.resourceGroupNames = EntityNameListCopier.copy(resourceGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupNames(String ... resourceGroupNames) {
            this.resourceGroupNames(Arrays.asList(resourceGroupNames));
            return this;
        }

        public final Collection<String> getResourceNames() {
            if (this.resourceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceNames;
        }

        public final void setResourceNames(Collection<String> resourceNames) {
            this.resourceNames = EntityNameListCopier.copy(resourceNames);
        }

        @Override
        public final Builder resourceNames(Collection<String> resourceNames) {
            this.resourceNames = EntityNameListCopier.copy(resourceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceNames(String ... resourceNames) {
            this.resourceNames(Arrays.asList(resourceNames));
            return this;
        }

        public final Collection<String> getTerraformSourceNames() {
            if (this.terraformSourceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.terraformSourceNames;
        }

        public final void setTerraformSourceNames(Collection<String> terraformSourceNames) {
            this.terraformSourceNames = String255ListCopier.copy(terraformSourceNames);
        }

        @Override
        public final Builder terraformSourceNames(Collection<String> terraformSourceNames) {
            this.terraformSourceNames = String255ListCopier.copy(terraformSourceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSourceNames(String ... terraformSourceNames) {
            this.terraformSourceNames(Arrays.asList(terraformSourceNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveDraftAppVersionResourceMappingsRequest build() {
            return new RemoveDraftAppVersionResourceMappingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveDraftAppVersionResourceMappingsRequest> {
        public Builder appArn(String var1);

        public Builder appRegistryAppNames(Collection<String> var1);

        public Builder appRegistryAppNames(String ... var1);

        public Builder eksSourceNames(Collection<String> var1);

        public Builder eksSourceNames(String ... var1);

        public Builder logicalStackNames(Collection<String> var1);

        public Builder logicalStackNames(String ... var1);

        public Builder resourceGroupNames(Collection<String> var1);

        public Builder resourceGroupNames(String ... var1);

        public Builder resourceNames(Collection<String> var1);

        public Builder resourceNames(String ... var1);

        public Builder terraformSourceNames(Collection<String> var1);

        public Builder terraformSourceNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

