/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails> {
    private static final SdkField<String> MARKET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MarketType").getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails::marketType)).setter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.setter(Builder::marketType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketType").build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails> SPOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotOptions").getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.getter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails::spotOptions)).setter(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.setter(Builder::spotOptions)).constructor(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKET_TYPE_FIELD, SPOT_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String marketType;
    private final AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions;

    private AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(BuilderImpl builder) {
        this.marketType = builder.marketType;
        this.spotOptions = builder.spotOptions;
    }

    public final String marketType() {
        return this.marketType;
    }

    public final AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions() {
        return this.spotOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marketType());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails other = (AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails)obj;
        return Objects.equals(this.marketType(), other.marketType()) && Objects.equals(this.spotOptions(), other.spotOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails").add("MarketType", (Object)this.marketType()).add("SpotOptions", (Object)this.spotOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MarketType": {
                return Optional.ofNullable(clazz.cast(this.marketType()));
            }
            case "SpotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String marketType;
        private AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails model) {
            this.marketType(model.marketType);
            this.spotOptions(model.spotOptions);
        }

        public final String getMarketType() {
            return this.marketType;
        }

        public final void setMarketType(String marketType) {
            this.marketType = marketType;
        }

        @Override
        public final Builder marketType(String marketType) {
            this.marketType = marketType;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails> {
        public Builder marketType(String var1);

        public Builder spotOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails var1);

        default public Builder spotOptions(Consumer<AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder> spotOptions) {
            return this.spotOptions((AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails)((AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.Builder)AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.builder().applyMutation(spotOptions)).build());
        }
    }
}

