/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionCode;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionEnvironment;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionLayer;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionLayerListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionTracingConfig;
import software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionVpcConfig;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsLambdaFunctionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsLambdaFunctionDetails> {
    private static final SdkField<AwsLambdaFunctionCode> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::code)).setter(AwsLambdaFunctionDetails.setter(Builder::code)).constructor(AwsLambdaFunctionCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSha256").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::codeSha256)).setter(AwsLambdaFunctionDetails.setter(Builder::codeSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()}).build();
    private static final SdkField<AwsLambdaFunctionDeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::deadLetterConfig)).setter(AwsLambdaFunctionDetails.setter(Builder::deadLetterConfig)).constructor(AwsLambdaFunctionDeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<AwsLambdaFunctionEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Environment").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::environment)).setter(AwsLambdaFunctionDetails.setter(Builder::environment)).constructor(AwsLambdaFunctionEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::functionName)).setter(AwsLambdaFunctionDetails.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Handler").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::handler)).setter(AwsLambdaFunctionDetails.setter(Builder::handler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::kmsKeyArn)).setter(AwsLambdaFunctionDetails.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::lastModified)).setter(AwsLambdaFunctionDetails.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<List<AwsLambdaFunctionLayer>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Layers").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::layers)).setter(AwsLambdaFunctionDetails.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsLambdaFunctionLayer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MASTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterArn").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::masterArn)).setter(AwsLambdaFunctionDetails.setter(Builder::masterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterArn").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemorySize").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::memorySize)).setter(AwsLambdaFunctionDetails.setter(Builder::memorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::revisionId)).setter(AwsLambdaFunctionDetails.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::role)).setter(AwsLambdaFunctionDetails.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Runtime").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::runtime)).setter(AwsLambdaFunctionDetails.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::timeout)).setter(AwsLambdaFunctionDetails.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<AwsLambdaFunctionTracingConfig> TRACING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TracingConfig").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::tracingConfig)).setter(AwsLambdaFunctionDetails.setter(Builder::tracingConfig)).constructor(AwsLambdaFunctionTracingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()}).build();
    private static final SdkField<AwsLambdaFunctionVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::vpcConfig)).setter(AwsLambdaFunctionDetails.setter(Builder::vpcConfig)).constructor(AwsLambdaFunctionVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::version)).setter(AwsLambdaFunctionDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Architectures").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::architectures)).setter(AwsLambdaFunctionDetails.setter(Builder::architectures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(AwsLambdaFunctionDetails.getter(AwsLambdaFunctionDetails::packageType)).setter(AwsLambdaFunctionDetails.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, CODE_SHA256_FIELD, DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, FUNCTION_NAME_FIELD, HANDLER_FIELD, KMS_KEY_ARN_FIELD, LAST_MODIFIED_FIELD, LAYERS_FIELD, MASTER_ARN_FIELD, MEMORY_SIZE_FIELD, REVISION_ID_FIELD, ROLE_FIELD, RUNTIME_FIELD, TIMEOUT_FIELD, TRACING_CONFIG_FIELD, VPC_CONFIG_FIELD, VERSION_FIELD, ARCHITECTURES_FIELD, PACKAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsLambdaFunctionCode code;
    private final String codeSha256;
    private final AwsLambdaFunctionDeadLetterConfig deadLetterConfig;
    private final AwsLambdaFunctionEnvironment environment;
    private final String functionName;
    private final String handler;
    private final String kmsKeyArn;
    private final String lastModified;
    private final List<AwsLambdaFunctionLayer> layers;
    private final String masterArn;
    private final Integer memorySize;
    private final String revisionId;
    private final String role;
    private final String runtime;
    private final Integer timeout;
    private final AwsLambdaFunctionTracingConfig tracingConfig;
    private final AwsLambdaFunctionVpcConfig vpcConfig;
    private final String version;
    private final List<String> architectures;
    private final String packageType;

    private AwsLambdaFunctionDetails(BuilderImpl builder) {
        this.code = builder.code;
        this.codeSha256 = builder.codeSha256;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.functionName = builder.functionName;
        this.handler = builder.handler;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastModified = builder.lastModified;
        this.layers = builder.layers;
        this.masterArn = builder.masterArn;
        this.memorySize = builder.memorySize;
        this.revisionId = builder.revisionId;
        this.role = builder.role;
        this.runtime = builder.runtime;
        this.timeout = builder.timeout;
        this.tracingConfig = builder.tracingConfig;
        this.vpcConfig = builder.vpcConfig;
        this.version = builder.version;
        this.architectures = builder.architectures;
        this.packageType = builder.packageType;
    }

    public final AwsLambdaFunctionCode code() {
        return this.code;
    }

    public final String codeSha256() {
        return this.codeSha256;
    }

    public final AwsLambdaFunctionDeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final AwsLambdaFunctionEnvironment environment() {
        return this.environment;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String handler() {
        return this.handler;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public final boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public final List<AwsLambdaFunctionLayer> layers() {
        return this.layers;
    }

    public final String masterArn() {
        return this.masterArn;
    }

    public final Integer memorySize() {
        return this.memorySize;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String role() {
        return this.role;
    }

    public final String runtime() {
        return this.runtime;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final AwsLambdaFunctionTracingConfig tracingConfig() {
        return this.tracingConfig;
    }

    public final AwsLambdaFunctionVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<String> architectures() {
        return this.architectures;
    }

    public final String packageType() {
        return this.packageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.masterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architectures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.packageType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaFunctionDetails)) {
            return false;
        }
        AwsLambdaFunctionDetails other = (AwsLambdaFunctionDetails)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.lastModified(), other.lastModified()) && this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && Objects.equals(this.masterArn(), other.masterArn()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.runtime(), other.runtime()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.tracingConfig(), other.tracingConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.version(), other.version()) && this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architectures(), other.architectures()) && Objects.equals(this.packageType(), other.packageType());
    }

    public final String toString() {
        return ToString.builder((String)"AwsLambdaFunctionDetails").add("Code", (Object)this.code()).add("CodeSha256", (Object)this.codeSha256()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("Environment", (Object)this.environment()).add("FunctionName", (Object)this.functionName()).add("Handler", (Object)this.handler()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("LastModified", (Object)this.lastModified()).add("Layers", this.hasLayers() ? this.layers() : null).add("MasterArn", (Object)this.masterArn()).add("MemorySize", (Object)this.memorySize()).add("RevisionId", (Object)this.revisionId()).add("Role", (Object)this.role()).add("Runtime", (Object)this.runtime()).add("Timeout", (Object)this.timeout()).add("TracingConfig", (Object)this.tracingConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("Version", (Object)this.version()).add("Architectures", this.hasArchitectures() ? this.architectures() : null).add("PackageType", (Object)this.packageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "CodeSha256": {
                return Optional.ofNullable(clazz.cast(this.codeSha256()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Handler": {
                return Optional.ofNullable(clazz.cast(this.handler()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "MasterArn": {
                return Optional.ofNullable(clazz.cast(this.masterArn()));
            }
            case "MemorySize": {
                return Optional.ofNullable(clazz.cast(this.memorySize()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Runtime": {
                return Optional.ofNullable(clazz.cast(this.runtime()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "TracingConfig": {
                return Optional.ofNullable(clazz.cast(this.tracingConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Architectures": {
                return Optional.ofNullable(clazz.cast(this.architectures()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaFunctionDetails, T> g) {
        return obj -> g.apply((AwsLambdaFunctionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsLambdaFunctionCode code;
        private String codeSha256;
        private AwsLambdaFunctionDeadLetterConfig deadLetterConfig;
        private AwsLambdaFunctionEnvironment environment;
        private String functionName;
        private String handler;
        private String kmsKeyArn;
        private String lastModified;
        private List<AwsLambdaFunctionLayer> layers = DefaultSdkAutoConstructList.getInstance();
        private String masterArn;
        private Integer memorySize;
        private String revisionId;
        private String role;
        private String runtime;
        private Integer timeout;
        private AwsLambdaFunctionTracingConfig tracingConfig;
        private AwsLambdaFunctionVpcConfig vpcConfig;
        private String version;
        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();
        private String packageType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaFunctionDetails model) {
            this.code(model.code);
            this.codeSha256(model.codeSha256);
            this.deadLetterConfig(model.deadLetterConfig);
            this.environment(model.environment);
            this.functionName(model.functionName);
            this.handler(model.handler);
            this.kmsKeyArn(model.kmsKeyArn);
            this.lastModified(model.lastModified);
            this.layers(model.layers);
            this.masterArn(model.masterArn);
            this.memorySize(model.memorySize);
            this.revisionId(model.revisionId);
            this.role(model.role);
            this.runtime(model.runtime);
            this.timeout(model.timeout);
            this.tracingConfig(model.tracingConfig);
            this.vpcConfig(model.vpcConfig);
            this.version(model.version);
            this.architectures(model.architectures);
            this.packageType(model.packageType);
        }

        public final AwsLambdaFunctionCode.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(AwsLambdaFunctionCode.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(AwsLambdaFunctionCode code) {
            this.code = code;
            return this;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final AwsLambdaFunctionDeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(AwsLambdaFunctionDeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(AwsLambdaFunctionDeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final AwsLambdaFunctionEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(AwsLambdaFunctionEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(AwsLambdaFunctionEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getHandler() {
            return this.handler;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final List<AwsLambdaFunctionLayer.Builder> getLayers() {
            List<AwsLambdaFunctionLayer.Builder> result = AwsLambdaFunctionLayerListCopier.copyToBuilder(this.layers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayers(Collection<AwsLambdaFunctionLayer.BuilderImpl> layers) {
            this.layers = AwsLambdaFunctionLayerListCopier.copyFromBuilder(layers);
        }

        @Override
        public final Builder layers(Collection<AwsLambdaFunctionLayer> layers) {
            this.layers = AwsLambdaFunctionLayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(AwsLambdaFunctionLayer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<AwsLambdaFunctionLayer.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (AwsLambdaFunctionLayer)((AwsLambdaFunctionLayer.Builder)AwsLambdaFunctionLayer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMasterArn() {
            return this.masterArn;
        }

        public final void setMasterArn(String masterArn) {
            this.masterArn = masterArn;
        }

        @Override
        public final Builder masterArn(String masterArn) {
            this.masterArn = masterArn;
            return this;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final AwsLambdaFunctionTracingConfig.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        public final void setTracingConfig(AwsLambdaFunctionTracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        @Override
        public final Builder tracingConfig(AwsLambdaFunctionTracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final AwsLambdaFunctionVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(AwsLambdaFunctionVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(AwsLambdaFunctionVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (this.architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = NonEmptyStringListCopier.copy(architectures);
        }

        @Override
        public final Builder architectures(Collection<String> architectures) {
            this.architectures = NonEmptyStringListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(String ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        public AwsLambdaFunctionDetails build() {
            return new AwsLambdaFunctionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsLambdaFunctionDetails> {
        public Builder code(AwsLambdaFunctionCode var1);

        default public Builder code(Consumer<AwsLambdaFunctionCode.Builder> code) {
            return this.code((AwsLambdaFunctionCode)((AwsLambdaFunctionCode.Builder)AwsLambdaFunctionCode.builder().applyMutation(code)).build());
        }

        public Builder codeSha256(String var1);

        public Builder deadLetterConfig(AwsLambdaFunctionDeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<AwsLambdaFunctionDeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((AwsLambdaFunctionDeadLetterConfig)((AwsLambdaFunctionDeadLetterConfig.Builder)AwsLambdaFunctionDeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder environment(AwsLambdaFunctionEnvironment var1);

        default public Builder environment(Consumer<AwsLambdaFunctionEnvironment.Builder> environment) {
            return this.environment((AwsLambdaFunctionEnvironment)((AwsLambdaFunctionEnvironment.Builder)AwsLambdaFunctionEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder functionName(String var1);

        public Builder handler(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder lastModified(String var1);

        public Builder layers(Collection<AwsLambdaFunctionLayer> var1);

        public Builder layers(AwsLambdaFunctionLayer ... var1);

        public Builder layers(Consumer<AwsLambdaFunctionLayer.Builder> ... var1);

        public Builder masterArn(String var1);

        public Builder memorySize(Integer var1);

        public Builder revisionId(String var1);

        public Builder role(String var1);

        public Builder runtime(String var1);

        public Builder timeout(Integer var1);

        public Builder tracingConfig(AwsLambdaFunctionTracingConfig var1);

        default public Builder tracingConfig(Consumer<AwsLambdaFunctionTracingConfig.Builder> tracingConfig) {
            return this.tracingConfig((AwsLambdaFunctionTracingConfig)((AwsLambdaFunctionTracingConfig.Builder)AwsLambdaFunctionTracingConfig.builder().applyMutation(tracingConfig)).build());
        }

        public Builder vpcConfig(AwsLambdaFunctionVpcConfig var1);

        default public Builder vpcConfig(Consumer<AwsLambdaFunctionVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((AwsLambdaFunctionVpcConfig)((AwsLambdaFunctionVpcConfig.Builder)AwsLambdaFunctionVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder version(String var1);

        public Builder architectures(Collection<String> var1);

        public Builder architectures(String ... var1);

        public Builder packageType(String var1);
    }
}

