/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketVersioningConfiguration;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketLoggingConfiguration;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfiguration;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketObjectLockConfiguration;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsS3BucketDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsS3BucketDetails> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::ownerId)).setter(AwsS3BucketDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> OWNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerName").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::ownerName)).setter(AwsS3BucketDetails.setter(Builder::ownerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerName").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::ownerAccountId)).setter(AwsS3BucketDetails.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::createdAt)).setter(AwsS3BucketDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<AwsS3BucketServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerSideEncryptionConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::serverSideEncryptionConfiguration)).setter(AwsS3BucketDetails.setter(Builder::serverSideEncryptionConfiguration)).constructor(AwsS3BucketServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration").build()}).build();
    private static final SdkField<AwsS3BucketBucketLifecycleConfigurationDetails> BUCKET_LIFECYCLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketLifecycleConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::bucketLifecycleConfiguration)).setter(AwsS3BucketDetails.setter(Builder::bucketLifecycleConfiguration)).constructor(AwsS3BucketBucketLifecycleConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLifecycleConfiguration").build()}).build();
    private static final SdkField<AwsS3AccountPublicAccessBlockDetails> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccessBlockConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::publicAccessBlockConfiguration)).setter(AwsS3BucketDetails.setter(Builder::publicAccessBlockConfiguration)).constructor(AwsS3AccountPublicAccessBlockDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration").build()}).build();
    private static final SdkField<String> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessControlList").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::accessControlList)).setter(AwsS3BucketDetails.setter(Builder::accessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build()}).build();
    private static final SdkField<AwsS3BucketLoggingConfiguration> BUCKET_LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketLoggingConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::bucketLoggingConfiguration)).setter(AwsS3BucketDetails.setter(Builder::bucketLoggingConfiguration)).constructor(AwsS3BucketLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLoggingConfiguration").build()}).build();
    private static final SdkField<AwsS3BucketWebsiteConfiguration> BUCKET_WEBSITE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketWebsiteConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::bucketWebsiteConfiguration)).setter(AwsS3BucketDetails.setter(Builder::bucketWebsiteConfiguration)).constructor(AwsS3BucketWebsiteConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketWebsiteConfiguration").build()}).build();
    private static final SdkField<AwsS3BucketNotificationConfiguration> BUCKET_NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketNotificationConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::bucketNotificationConfiguration)).setter(AwsS3BucketDetails.setter(Builder::bucketNotificationConfiguration)).constructor(AwsS3BucketNotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketNotificationConfiguration").build()}).build();
    private static final SdkField<AwsS3BucketBucketVersioningConfiguration> BUCKET_VERSIONING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketVersioningConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::bucketVersioningConfiguration)).setter(AwsS3BucketDetails.setter(Builder::bucketVersioningConfiguration)).constructor(AwsS3BucketBucketVersioningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketVersioningConfiguration").build()}).build();
    private static final SdkField<AwsS3BucketObjectLockConfiguration> OBJECT_LOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ObjectLockConfiguration").getter(AwsS3BucketDetails.getter(AwsS3BucketDetails::objectLockConfiguration)).setter(AwsS3BucketDetails.setter(Builder::objectLockConfiguration)).constructor(AwsS3BucketObjectLockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, OWNER_NAME_FIELD, OWNER_ACCOUNT_ID_FIELD, CREATED_AT_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, BUCKET_LIFECYCLE_CONFIGURATION_FIELD, PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, ACCESS_CONTROL_LIST_FIELD, BUCKET_LOGGING_CONFIGURATION_FIELD, BUCKET_WEBSITE_CONFIGURATION_FIELD, BUCKET_NOTIFICATION_CONFIGURATION_FIELD, BUCKET_VERSIONING_CONFIGURATION_FIELD, OBJECT_LOCK_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ownerName;
    private final String ownerAccountId;
    private final String createdAt;
    private final AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration;
    private final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;
    private final String accessControlList;
    private final AwsS3BucketLoggingConfiguration bucketLoggingConfiguration;
    private final AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration;
    private final AwsS3BucketNotificationConfiguration bucketNotificationConfiguration;
    private final AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration;
    private final AwsS3BucketObjectLockConfiguration objectLockConfiguration;

    private AwsS3BucketDetails(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ownerName = builder.ownerName;
        this.ownerAccountId = builder.ownerAccountId;
        this.createdAt = builder.createdAt;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.bucketLifecycleConfiguration = builder.bucketLifecycleConfiguration;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.accessControlList = builder.accessControlList;
        this.bucketLoggingConfiguration = builder.bucketLoggingConfiguration;
        this.bucketWebsiteConfiguration = builder.bucketWebsiteConfiguration;
        this.bucketNotificationConfiguration = builder.bucketNotificationConfiguration;
        this.bucketVersioningConfiguration = builder.bucketVersioningConfiguration;
        this.objectLockConfiguration = builder.objectLockConfiguration;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ownerName() {
        return this.ownerName;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration() {
        return this.bucketLifecycleConfiguration;
    }

    public final AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration() {
        return this.publicAccessBlockConfiguration;
    }

    public final String accessControlList() {
        return this.accessControlList;
    }

    public final AwsS3BucketLoggingConfiguration bucketLoggingConfiguration() {
        return this.bucketLoggingConfiguration;
    }

    public final AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration() {
        return this.bucketWebsiteConfiguration;
    }

    public final AwsS3BucketNotificationConfiguration bucketNotificationConfiguration() {
        return this.bucketNotificationConfiguration;
    }

    public final AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration() {
        return this.bucketVersioningConfiguration;
    }

    public final AwsS3BucketObjectLockConfiguration objectLockConfiguration() {
        return this.objectLockConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketWebsiteConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketNotificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketVersioningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLockConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketDetails)) {
            return false;
        }
        AwsS3BucketDetails other = (AwsS3BucketDetails)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ownerName(), other.ownerName()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.bucketLifecycleConfiguration(), other.bucketLifecycleConfiguration()) && Objects.equals(this.publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration()) && Objects.equals(this.accessControlList(), other.accessControlList()) && Objects.equals(this.bucketLoggingConfiguration(), other.bucketLoggingConfiguration()) && Objects.equals(this.bucketWebsiteConfiguration(), other.bucketWebsiteConfiguration()) && Objects.equals(this.bucketNotificationConfiguration(), other.bucketNotificationConfiguration()) && Objects.equals(this.bucketVersioningConfiguration(), other.bucketVersioningConfiguration()) && Objects.equals(this.objectLockConfiguration(), other.objectLockConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AwsS3BucketDetails").add("OwnerId", (Object)this.ownerId()).add("OwnerName", (Object)this.ownerName()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("CreatedAt", (Object)this.createdAt()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("BucketLifecycleConfiguration", (Object)this.bucketLifecycleConfiguration()).add("PublicAccessBlockConfiguration", (Object)this.publicAccessBlockConfiguration()).add("AccessControlList", (Object)this.accessControlList()).add("BucketLoggingConfiguration", (Object)this.bucketLoggingConfiguration()).add("BucketWebsiteConfiguration", (Object)this.bucketWebsiteConfiguration()).add("BucketNotificationConfiguration", (Object)this.bucketNotificationConfiguration()).add("BucketVersioningConfiguration", (Object)this.bucketVersioningConfiguration()).add("ObjectLockConfiguration", (Object)this.objectLockConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "OwnerName": {
                return Optional.ofNullable(clazz.cast(this.ownerName()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ServerSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "BucketLifecycleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bucketLifecycleConfiguration()));
            }
            case "PublicAccessBlockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlockConfiguration()));
            }
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "BucketLoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bucketLoggingConfiguration()));
            }
            case "BucketWebsiteConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bucketWebsiteConfiguration()));
            }
            case "BucketNotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bucketNotificationConfiguration()));
            }
            case "BucketVersioningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bucketVersioningConfiguration()));
            }
            case "ObjectLockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.objectLockConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketDetails, T> g) {
        return obj -> g.apply((AwsS3BucketDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ownerName;
        private String ownerAccountId;
        private String createdAt;
        private AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration;
        private AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration;
        private String accessControlList;
        private AwsS3BucketLoggingConfiguration bucketLoggingConfiguration;
        private AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration;
        private AwsS3BucketNotificationConfiguration bucketNotificationConfiguration;
        private AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration;
        private AwsS3BucketObjectLockConfiguration objectLockConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketDetails model) {
            this.ownerId(model.ownerId);
            this.ownerName(model.ownerName);
            this.ownerAccountId(model.ownerAccountId);
            this.createdAt(model.createdAt);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.bucketLifecycleConfiguration(model.bucketLifecycleConfiguration);
            this.publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            this.accessControlList(model.accessControlList);
            this.bucketLoggingConfiguration(model.bucketLoggingConfiguration);
            this.bucketWebsiteConfiguration(model.bucketWebsiteConfiguration);
            this.bucketNotificationConfiguration(model.bucketNotificationConfiguration);
            this.bucketVersioningConfiguration(model.bucketVersioningConfiguration);
            this.objectLockConfiguration(model.objectLockConfiguration);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getOwnerName() {
            return this.ownerName;
        }

        public final void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        @Override
        public final Builder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final AwsS3BucketServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(AwsS3BucketServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(AwsS3BucketServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final AwsS3BucketBucketLifecycleConfigurationDetails.Builder getBucketLifecycleConfiguration() {
            return this.bucketLifecycleConfiguration != null ? this.bucketLifecycleConfiguration.toBuilder() : null;
        }

        public final void setBucketLifecycleConfiguration(AwsS3BucketBucketLifecycleConfigurationDetails.BuilderImpl bucketLifecycleConfiguration) {
            this.bucketLifecycleConfiguration = bucketLifecycleConfiguration != null ? bucketLifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder bucketLifecycleConfiguration(AwsS3BucketBucketLifecycleConfigurationDetails bucketLifecycleConfiguration) {
            this.bucketLifecycleConfiguration = bucketLifecycleConfiguration;
            return this;
        }

        public final AwsS3AccountPublicAccessBlockDetails.Builder getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build() : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final String getAccessControlList() {
            return this.accessControlList;
        }

        public final void setAccessControlList(String accessControlList) {
            this.accessControlList = accessControlList;
        }

        @Override
        public final Builder accessControlList(String accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final AwsS3BucketLoggingConfiguration.Builder getBucketLoggingConfiguration() {
            return this.bucketLoggingConfiguration != null ? this.bucketLoggingConfiguration.toBuilder() : null;
        }

        public final void setBucketLoggingConfiguration(AwsS3BucketLoggingConfiguration.BuilderImpl bucketLoggingConfiguration) {
            this.bucketLoggingConfiguration = bucketLoggingConfiguration != null ? bucketLoggingConfiguration.build() : null;
        }

        @Override
        public final Builder bucketLoggingConfiguration(AwsS3BucketLoggingConfiguration bucketLoggingConfiguration) {
            this.bucketLoggingConfiguration = bucketLoggingConfiguration;
            return this;
        }

        public final AwsS3BucketWebsiteConfiguration.Builder getBucketWebsiteConfiguration() {
            return this.bucketWebsiteConfiguration != null ? this.bucketWebsiteConfiguration.toBuilder() : null;
        }

        public final void setBucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration.BuilderImpl bucketWebsiteConfiguration) {
            this.bucketWebsiteConfiguration = bucketWebsiteConfiguration != null ? bucketWebsiteConfiguration.build() : null;
        }

        @Override
        public final Builder bucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration bucketWebsiteConfiguration) {
            this.bucketWebsiteConfiguration = bucketWebsiteConfiguration;
            return this;
        }

        public final AwsS3BucketNotificationConfiguration.Builder getBucketNotificationConfiguration() {
            return this.bucketNotificationConfiguration != null ? this.bucketNotificationConfiguration.toBuilder() : null;
        }

        public final void setBucketNotificationConfiguration(AwsS3BucketNotificationConfiguration.BuilderImpl bucketNotificationConfiguration) {
            this.bucketNotificationConfiguration = bucketNotificationConfiguration != null ? bucketNotificationConfiguration.build() : null;
        }

        @Override
        public final Builder bucketNotificationConfiguration(AwsS3BucketNotificationConfiguration bucketNotificationConfiguration) {
            this.bucketNotificationConfiguration = bucketNotificationConfiguration;
            return this;
        }

        public final AwsS3BucketBucketVersioningConfiguration.Builder getBucketVersioningConfiguration() {
            return this.bucketVersioningConfiguration != null ? this.bucketVersioningConfiguration.toBuilder() : null;
        }

        public final void setBucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration.BuilderImpl bucketVersioningConfiguration) {
            this.bucketVersioningConfiguration = bucketVersioningConfiguration != null ? bucketVersioningConfiguration.build() : null;
        }

        @Override
        public final Builder bucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration bucketVersioningConfiguration) {
            this.bucketVersioningConfiguration = bucketVersioningConfiguration;
            return this;
        }

        public final AwsS3BucketObjectLockConfiguration.Builder getObjectLockConfiguration() {
            return this.objectLockConfiguration != null ? this.objectLockConfiguration.toBuilder() : null;
        }

        public final void setObjectLockConfiguration(AwsS3BucketObjectLockConfiguration.BuilderImpl objectLockConfiguration) {
            this.objectLockConfiguration = objectLockConfiguration != null ? objectLockConfiguration.build() : null;
        }

        @Override
        public final Builder objectLockConfiguration(AwsS3BucketObjectLockConfiguration objectLockConfiguration) {
            this.objectLockConfiguration = objectLockConfiguration;
            return this;
        }

        public AwsS3BucketDetails build() {
            return new AwsS3BucketDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsS3BucketDetails> {
        public Builder ownerId(String var1);

        public Builder ownerName(String var1);

        public Builder ownerAccountId(String var1);

        public Builder createdAt(String var1);

        public Builder serverSideEncryptionConfiguration(AwsS3BucketServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<AwsS3BucketServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((AwsS3BucketServerSideEncryptionConfiguration)((AwsS3BucketServerSideEncryptionConfiguration.Builder)AwsS3BucketServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder bucketLifecycleConfiguration(AwsS3BucketBucketLifecycleConfigurationDetails var1);

        default public Builder bucketLifecycleConfiguration(Consumer<AwsS3BucketBucketLifecycleConfigurationDetails.Builder> bucketLifecycleConfiguration) {
            return this.bucketLifecycleConfiguration((AwsS3BucketBucketLifecycleConfigurationDetails)((AwsS3BucketBucketLifecycleConfigurationDetails.Builder)AwsS3BucketBucketLifecycleConfigurationDetails.builder().applyMutation(bucketLifecycleConfiguration)).build());
        }

        public Builder publicAccessBlockConfiguration(AwsS3AccountPublicAccessBlockDetails var1);

        default public Builder publicAccessBlockConfiguration(Consumer<AwsS3AccountPublicAccessBlockDetails.Builder> publicAccessBlockConfiguration) {
            return this.publicAccessBlockConfiguration((AwsS3AccountPublicAccessBlockDetails)((AwsS3AccountPublicAccessBlockDetails.Builder)AwsS3AccountPublicAccessBlockDetails.builder().applyMutation(publicAccessBlockConfiguration)).build());
        }

        public Builder accessControlList(String var1);

        public Builder bucketLoggingConfiguration(AwsS3BucketLoggingConfiguration var1);

        default public Builder bucketLoggingConfiguration(Consumer<AwsS3BucketLoggingConfiguration.Builder> bucketLoggingConfiguration) {
            return this.bucketLoggingConfiguration((AwsS3BucketLoggingConfiguration)((AwsS3BucketLoggingConfiguration.Builder)AwsS3BucketLoggingConfiguration.builder().applyMutation(bucketLoggingConfiguration)).build());
        }

        public Builder bucketWebsiteConfiguration(AwsS3BucketWebsiteConfiguration var1);

        default public Builder bucketWebsiteConfiguration(Consumer<AwsS3BucketWebsiteConfiguration.Builder> bucketWebsiteConfiguration) {
            return this.bucketWebsiteConfiguration((AwsS3BucketWebsiteConfiguration)((AwsS3BucketWebsiteConfiguration.Builder)AwsS3BucketWebsiteConfiguration.builder().applyMutation(bucketWebsiteConfiguration)).build());
        }

        public Builder bucketNotificationConfiguration(AwsS3BucketNotificationConfiguration var1);

        default public Builder bucketNotificationConfiguration(Consumer<AwsS3BucketNotificationConfiguration.Builder> bucketNotificationConfiguration) {
            return this.bucketNotificationConfiguration((AwsS3BucketNotificationConfiguration)((AwsS3BucketNotificationConfiguration.Builder)AwsS3BucketNotificationConfiguration.builder().applyMutation(bucketNotificationConfiguration)).build());
        }

        public Builder bucketVersioningConfiguration(AwsS3BucketBucketVersioningConfiguration var1);

        default public Builder bucketVersioningConfiguration(Consumer<AwsS3BucketBucketVersioningConfiguration.Builder> bucketVersioningConfiguration) {
            return this.bucketVersioningConfiguration((AwsS3BucketBucketVersioningConfiguration)((AwsS3BucketBucketVersioningConfiguration.Builder)AwsS3BucketBucketVersioningConfiguration.builder().applyMutation(bucketVersioningConfiguration)).build());
        }

        public Builder objectLockConfiguration(AwsS3BucketObjectLockConfiguration var1);

        default public Builder objectLockConfiguration(Consumer<AwsS3BucketObjectLockConfiguration.Builder> objectLockConfiguration) {
            return this.objectLockConfiguration((AwsS3BucketObjectLockConfiguration)((AwsS3BucketObjectLockConfiguration.Builder)AwsS3BucketObjectLockConfiguration.builder().applyMutation(objectLockConfiguration)).build());
        }
    }
}

