/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId;
import software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnprocessedStandardsControlAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnprocessedStandardsControlAssociation> {
    private static final SdkField<StandardsControlAssociationId> STANDARDS_CONTROL_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StandardsControlAssociationId").getter(UnprocessedStandardsControlAssociation.getter(UnprocessedStandardsControlAssociation::standardsControlAssociationId)).setter(UnprocessedStandardsControlAssociation.setter(Builder::standardsControlAssociationId)).constructor(StandardsControlAssociationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(UnprocessedStandardsControlAssociation.getter(UnprocessedStandardsControlAssociation::errorCodeAsString)).setter(UnprocessedStandardsControlAssociation.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorReason").getter(UnprocessedStandardsControlAssociation.getter(UnprocessedStandardsControlAssociation::errorReason)).setter(UnprocessedStandardsControlAssociation.setter(Builder::errorReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ASSOCIATION_ID_FIELD, ERROR_CODE_FIELD, ERROR_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final StandardsControlAssociationId standardsControlAssociationId;
    private final String errorCode;
    private final String errorReason;

    private UnprocessedStandardsControlAssociation(BuilderImpl builder) {
        this.standardsControlAssociationId = builder.standardsControlAssociationId;
        this.errorCode = builder.errorCode;
        this.errorReason = builder.errorReason;
    }

    public final StandardsControlAssociationId standardsControlAssociationId() {
        return this.standardsControlAssociationId;
    }

    public final UnprocessedErrorCode errorCode() {
        return UnprocessedErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorReason() {
        return this.errorReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsControlAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedStandardsControlAssociation)) {
            return false;
        }
        UnprocessedStandardsControlAssociation other = (UnprocessedStandardsControlAssociation)obj;
        return Objects.equals(this.standardsControlAssociationId(), other.standardsControlAssociationId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorReason(), other.errorReason());
    }

    public final String toString() {
        return ToString.builder((String)"UnprocessedStandardsControlAssociation").add("StandardsControlAssociationId", (Object)this.standardsControlAssociationId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorReason", (Object)this.errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsControlAssociationId": {
                return Optional.ofNullable(clazz.cast(this.standardsControlAssociationId()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorReason": {
                return Optional.ofNullable(clazz.cast(this.errorReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedStandardsControlAssociation, T> g) {
        return obj -> g.apply((UnprocessedStandardsControlAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StandardsControlAssociationId standardsControlAssociationId;
        private String errorCode;
        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedStandardsControlAssociation model) {
            this.standardsControlAssociationId(model.standardsControlAssociationId);
            this.errorCode(model.errorCode);
            this.errorReason(model.errorReason);
        }

        public final StandardsControlAssociationId.Builder getStandardsControlAssociationId() {
            return this.standardsControlAssociationId != null ? this.standardsControlAssociationId.toBuilder() : null;
        }

        public final void setStandardsControlAssociationId(StandardsControlAssociationId.BuilderImpl standardsControlAssociationId) {
            this.standardsControlAssociationId = standardsControlAssociationId != null ? standardsControlAssociationId.build() : null;
        }

        @Override
        public final Builder standardsControlAssociationId(StandardsControlAssociationId standardsControlAssociationId) {
            this.standardsControlAssociationId = standardsControlAssociationId;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UnprocessedErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorReason() {
            return this.errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public UnprocessedStandardsControlAssociation build() {
            return new UnprocessedStandardsControlAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnprocessedStandardsControlAssociation> {
        public Builder standardsControlAssociationId(StandardsControlAssociationId var1);

        default public Builder standardsControlAssociationId(Consumer<StandardsControlAssociationId.Builder> standardsControlAssociationId) {
            return this.standardsControlAssociationId((StandardsControlAssociationId)((StandardsControlAssociationId.Builder)StandardsControlAssociationId.builder().applyMutation(standardsControlAssociationId)).build());
        }

        public Builder errorCode(String var1);

        public Builder errorCode(UnprocessedErrorCode var1);

        public Builder errorReason(String var1);
    }
}

