/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.FindingAggregator;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse;

public class ListFindingAggregatorsPublisher
implements SdkPublisher<ListFindingAggregatorsResponse> {
    private final SecurityHubAsyncClient client;
    private final ListFindingAggregatorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingAggregatorsPublisher(SecurityHubAsyncClient client, ListFindingAggregatorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingAggregatorsPublisher(SecurityHubAsyncClient client, ListFindingAggregatorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingAggregatorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingAggregatorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FindingAggregator> findingAggregators() {
        Function<ListFindingAggregatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingAggregators() != null) {
                return response.findingAggregators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFindingAggregatorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFindingAggregatorsResponseFetcher
    implements AsyncPageFetcher<ListFindingAggregatorsResponse> {
        private ListFindingAggregatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingAggregatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingAggregatorsResponse> nextPage(ListFindingAggregatorsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingAggregatorsPublisher.this.client.listFindingAggregators(ListFindingAggregatorsPublisher.this.firstRequest);
            }
            return ListFindingAggregatorsPublisher.this.client.listFindingAggregators((ListFindingAggregatorsRequest)((Object)ListFindingAggregatorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

