/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.BlockAction;
import software.amazon.awssdk.services.shield.model.CountAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseAction> {
    private static final SdkField<BlockAction> BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Block").getter(ResponseAction.getter(ResponseAction::block)).setter(ResponseAction.setter(Builder::block)).constructor(BlockAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()}).build();
    private static final SdkField<CountAction> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Count").getter(ResponseAction.getter(ResponseAction::count)).setter(ResponseAction.setter(Builder::count)).constructor(CountAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_FIELD, COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final BlockAction block;
    private final CountAction count;

    private ResponseAction(BuilderImpl builder) {
        this.block = builder.block;
        this.count = builder.count;
    }

    public final BlockAction block() {
        return this.block;
    }

    public final CountAction count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.block());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseAction)) {
            return false;
        }
        ResponseAction other = (ResponseAction)obj;
        return Objects.equals(this.block(), other.block()) && Objects.equals(this.count(), other.count());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseAction").add("Block", (Object)this.block()).add("Count", (Object)this.count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Block": {
                return Optional.ofNullable(clazz.cast(this.block()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseAction, T> g) {
        return obj -> g.apply((ResponseAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BlockAction block;
        private CountAction count;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseAction model) {
            this.block(model.block);
            this.count(model.count);
        }

        public final BlockAction.Builder getBlock() {
            return this.block != null ? this.block.toBuilder() : null;
        }

        public final void setBlock(BlockAction.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        @Override
        public final Builder block(BlockAction block) {
            this.block = block;
            return this;
        }

        public final CountAction.Builder getCount() {
            return this.count != null ? this.count.toBuilder() : null;
        }

        public final void setCount(CountAction.BuilderImpl count) {
            this.count = count != null ? count.build() : null;
        }

        @Override
        public final Builder count(CountAction count) {
            this.count = count;
            return this;
        }

        public ResponseAction build() {
            return new ResponseAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseAction> {
        public Builder block(BlockAction var1);

        default public Builder block(Consumer<BlockAction.Builder> block) {
            return this.block((BlockAction)((BlockAction.Builder)BlockAction.builder().applyMutation(block)).build());
        }

        public Builder count(CountAction var1);

        default public Builder count(Consumer<CountAction.Builder> count) {
            return this.count((CountAction)((CountAction.Builder)CountAction.builder().applyMutation(count)).build());
        }
    }
}

