/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.filter.impl;

import com.alibaba.nacos.api.config.filter.AbstractConfigFilter;
import com.alibaba.nacos.api.config.filter.IConfigFilterChain;
import com.alibaba.nacos.api.config.filter.IConfigRequest;
import com.alibaba.nacos.api.config.filter.IConfigResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigRequest;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.util.Objects;
import java.util.Properties;

public class ConfigEncryptionFilter
extends AbstractConfigFilter {
    private static final String DEFAULT_NAME = ConfigEncryptionFilter.class.getName();

    public void init(Properties properties) {
    }

    public void doFilter(IConfigRequest request, IConfigResponse response, IConfigFilterChain filterChain) throws NacosException {
        String dataId;
        if (Objects.nonNull(request) && request instanceof ConfigRequest && Objects.isNull(response)) {
            ConfigRequest configRequest = (ConfigRequest)request;
            dataId = configRequest.getDataId();
            String content = configRequest.getContent();
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            String secretKey = (String)pair.getFirst();
            String encryptContent = (String)pair.getSecond();
            ((ConfigRequest)request).setContent(encryptContent);
            ((ConfigRequest)request).setEncryptedDataKey(secretKey);
        }
        if (Objects.nonNull(response) && response instanceof ConfigResponse && Objects.isNull(request)) {
            ConfigResponse configResponse = (ConfigResponse)response;
            dataId = configResponse.getDataId();
            String encryptedDataKey = configResponse.getEncryptedDataKey();
            String content = configResponse.getContent();
            Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)content);
            String decryptContent = (String)pair.getSecond();
            ((ConfigResponse)response).setContent(decryptContent);
        }
        filterChain.doFilter(request, response);
    }

    public int getOrder() {
        return 0;
    }

    public String getFilterName() {
        return DEFAULT_NAME;
    }
}

