/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.capacity;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.capacity.TenantCapacity;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class TenantCapacityPersistService {
    private static final TenantCapacityRowMapper TENANT_CAPACITY_ROW_MAPPER = new TenantCapacityRowMapper();
    private JdbcTemplate jdbcTemplate;
    private DataSourceService dataSourceService;

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jdbcTemplate = this.dataSourceService.getJdbcTemplate();
    }

    public TenantCapacity getTenantCapacity(String tenantId) {
        String sql = "SELECT id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, tenant_id FROM tenant_capacity WHERE tenant_id=?";
        List list = this.jdbcTemplate.query(sql, new Object[]{tenantId}, (RowMapper)TENANT_CAPACITY_ROW_MAPPER);
        if (list.isEmpty()) {
            return null;
        }
        return (TenantCapacity)list.get(0);
    }

    public boolean insertTenantCapacity(TenantCapacity tenantCapacity) {
        String sql = "INSERT INTO tenant_capacity (tenant_id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info WHERE tenant_id=?;";
        try {
            GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO tenant_capacity (tenant_id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info WHERE tenant_id=?;", 1);
                String tenant = tenantCapacity.getTenant();
                ps.setString(1, tenant);
                ps.setInt(2, tenantCapacity.getQuota());
                ps.setInt(3, tenantCapacity.getMaxSize());
                ps.setInt(4, tenantCapacity.getMaxAggrCount());
                ps.setInt(5, tenantCapacity.getMaxAggrSize());
                ps.setTimestamp(6, tenantCapacity.getGmtCreate());
                ps.setTimestamp(7, tenantCapacity.getGmtModified());
                ps.setString(8, tenantCapacity.getTenant());
                return ps;
            };
            this.jdbcTemplate.update(preparedStatementCreator, (KeyHolder)generatedKeyHolder);
            return generatedKeyHolder.getKey() != null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithDefaultQuotaLimit(TenantCapacity tenantCapacity) {
        String sql = "UPDATE tenant_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE tenant_id = ? AND `usage` < ? AND quota = 0";
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{tenantCapacity.getGmtModified(), tenantCapacity.getTenant(), tenantCapacity.getQuota()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithQuotaLimit(TenantCapacity tenantCapacity) {
        String sql = "UPDATE tenant_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE tenant_id = ? AND `usage` < quota AND quota != 0";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{tenantCapacity.getGmtModified(), tenantCapacity.getTenant()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsage(TenantCapacity tenantCapacity) {
        String sql = "UPDATE tenant_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE tenant_id = ?";
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{tenantCapacity.getGmtModified(), tenantCapacity.getTenant()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean decrementUsage(TenantCapacity tenantCapacity) {
        String sql = "UPDATE tenant_capacity SET `usage` = `usage` - 1, gmt_modified = ? WHERE tenant_id = ? AND `usage` > 0";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{tenantCapacity.getGmtModified(), tenantCapacity.getTenant()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateTenantCapacity(String tenant, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        List argList = CollectionUtils.list((Object[])new Object[0]);
        StringBuilder sql = new StringBuilder("UPDATE tenant_capacity SET");
        if (quota != null) {
            sql.append(" quota = ?,");
            argList.add(quota);
        }
        if (maxSize != null) {
            sql.append(" max_size = ?,");
            argList.add(maxSize);
        }
        if (maxAggrCount != null) {
            sql.append(" max_aggr_count = ?,");
            argList.add(maxAggrCount);
        }
        if (maxAggrSize != null) {
            sql.append(" max_aggr_size = ?,");
            argList.add(maxAggrSize);
        }
        sql.append(" gmt_modified = ?");
        argList.add(TimeUtils.getCurrentTime());
        sql.append(" WHERE tenant_id = ?");
        argList.add(tenant);
        try {
            return this.jdbcTemplate.update(sql.toString(), argList.toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateQuota(String tenant, Integer quota) {
        return this.updateTenantCapacity(tenant, quota, null, null, null);
    }

    public boolean correctUsage(String tenant, Timestamp gmtModified) {
        String sql = "UPDATE tenant_capacity SET `usage` = (SELECT count(*) FROM config_info WHERE tenant_id = ?), gmt_modified = ? WHERE tenant_id = ?";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{tenant, gmtModified, tenant}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public List<TenantCapacity> getCapacityList4CorrectUsage(long lastId, int pageSize) {
        String sql = "SELECT id, tenant_id FROM tenant_capacity WHERE id>? LIMIT ?";
        if (PropertyUtil.isEmbeddedStorage()) {
            sql = "SELECT id, tenant_id FROM tenant_capacity WHERE id>? OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY";
        }
        try {
            return this.jdbcTemplate.query(sql, new Object[]{lastId, pageSize}, (RowMapper)new RowMapper<TenantCapacity>(){

                public TenantCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
                    TenantCapacity tenantCapacity = new TenantCapacity();
                    tenantCapacity.setId(rs.getLong("id"));
                    tenantCapacity.setTenant(rs.getString("tenant_id"));
                    return tenantCapacity;
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean deleteTenantCapacity(String tenant) {
        try {
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement("DELETE FROM tenant_capacity WHERE tenant_id = ?;");
                ps.setString(1, tenant);
                return ps;
            };
            return this.jdbcTemplate.update(preparedStatementCreator) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    private static final class TenantCapacityRowMapper
    implements RowMapper<TenantCapacity> {
        private TenantCapacityRowMapper() {
        }

        public TenantCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
            TenantCapacity tenantCapacity = new TenantCapacity();
            tenantCapacity.setId(rs.getLong("id"));
            tenantCapacity.setQuota(rs.getInt("quota"));
            tenantCapacity.setUsage(rs.getInt("usage"));
            tenantCapacity.setMaxSize(rs.getInt("max_size"));
            tenantCapacity.setMaxAggrCount(rs.getInt("max_aggr_count"));
            tenantCapacity.setMaxAggrSize(rs.getInt("max_aggr_size"));
            tenantCapacity.setTenant(rs.getString("tenant_id"));
            return tenantCapacity;
        }
    }
}

