/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.rule.storage;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.rule.ControlRuleChangeActivator;
import com.alibaba.nacos.plugin.control.rule.storage.ExternalRuleStorage;
import com.alibaba.nacos.plugin.control.rule.storage.LocalDiskRuleStorage;
import com.alibaba.nacos.plugin.control.rule.storage.RuleStorage;
import com.alibaba.nacos.plugin.control.spi.ExternalRuleStorageBuilder;
import java.util.Collection;
import org.slf4j.Logger;

public class RuleStorageProxy {
    private static final Logger LOGGER = Loggers.CONTROL;
    private static final RuleStorageProxy INSTANCE = new RuleStorageProxy();
    private LocalDiskRuleStorage localDiskRuleStorage = null;
    private ExternalRuleStorage externalRuleStorage = null;
    ControlRuleChangeActivator controlRuleChangeActivator = null;

    private RuleStorageProxy() {
        String externalStorageType = ControlConfigs.getInstance().getRuleExternalStorage();
        if (StringUtils.isNotEmpty((String)externalStorageType)) {
            this.buildExternalStorage(externalStorageType);
        }
        this.initLocalStorage();
        this.controlRuleChangeActivator = new ControlRuleChangeActivator();
    }

    private void buildExternalStorage(String externalStorageType) {
        Collection externalRuleStorageBuilders = NacosServiceLoader.load(ExternalRuleStorageBuilder.class);
        for (ExternalRuleStorageBuilder each : externalRuleStorageBuilders) {
            LOGGER.info("Found persist rule storage of name : {}", (Object)externalStorageType);
            if (!externalStorageType.equalsIgnoreCase(each.getName())) continue;
            try {
                this.externalRuleStorage = each.buildExternalRuleStorage();
            }
            catch (Exception e) {
                LOGGER.warn("Build external rule storage failed, the rules will not be persisted", (Throwable)e);
            }
            LOGGER.info("Build external rule storage of name {} finished", (Object)externalStorageType);
            break;
        }
        if (this.externalRuleStorage == null && StringUtils.isNotBlank((String)externalStorageType)) {
            LOGGER.error("Fail to found persist rule storage of name : {}", (Object)externalStorageType);
        }
    }

    private void initLocalStorage() {
        this.localDiskRuleStorage = new LocalDiskRuleStorage();
        if (StringUtils.isNotBlank((String)ControlConfigs.getInstance().getLocalRuleStorageBaseDir())) {
            this.localDiskRuleStorage.setLocalRuleBaseDir(ControlConfigs.getInstance().getLocalRuleStorageBaseDir());
        }
    }

    public RuleStorage getLocalDiskStorage() {
        return this.localDiskRuleStorage;
    }

    public RuleStorage getExternalStorage() {
        return this.externalRuleStorage;
    }

    public static RuleStorageProxy getInstance() {
        return INSTANCE;
    }
}

