/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.auth.HttpProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthFilter
implements Filter {
    private final AuthConfigs authConfigs;
    private final ControllerMethodsCache methodsCache;
    private final HttpProtocolAuthService protocolAuthService;

    public AuthFilter(AuthConfigs authConfigs, ControllerMethodsCache methodsCache) {
        this.authConfigs = authConfigs;
        this.methodsCache = methodsCache;
        this.protocolAuthService = new HttpProtocolAuthService(authConfigs);
        this.protocolAuthService.initialize();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.authConfigs.isAuthEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.authConfigs.isEnableUserAgentAuthWhite()) {
            String userAgent = WebUtils.getUserAgent(req);
            if (StringUtils.startsWith((CharSequence)userAgent, (CharSequence)"Nacos-Server")) {
                chain.doFilter(request, response);
                return;
            }
        } else if (StringUtils.isNotBlank((String)this.authConfigs.getServerIdentityKey()) && StringUtils.isNotBlank((String)this.authConfigs.getServerIdentityValue())) {
            String serverIdentity = req.getHeader(this.authConfigs.getServerIdentityKey());
            if (StringUtils.isNotBlank((String)serverIdentity)) {
                if (this.authConfigs.getServerIdentityValue().equals(serverIdentity)) {
                    chain.doFilter(request, response);
                    return;
                }
                Loggers.AUTH.warn("Invalid server identity value for {} from {}", (Object)this.authConfigs.getServerIdentityKey(), (Object)req.getRemoteHost());
            }
        } else {
            resp.sendError(403, "Invalid server identity key or value, Please make sure set `nacos.core.auth.server.identity.key` and `nacos.core.auth.server.identity.value`, or open `nacos.core.auth.enable.userAgentAuthWhite`");
            return;
        }
        try {
            Method method = this.methodsCache.getMethod(req);
            if (method == null) {
                chain.doFilter(request, response);
                return;
            }
            if (method.isAnnotationPresent(Secured.class) && this.authConfigs.isAuthEnabled()) {
                Secured secured;
                if (Loggers.AUTH.isDebugEnabled()) {
                    Loggers.AUTH.debug("auth start, request: {} {}", (Object)req.getMethod(), (Object)req.getRequestURI());
                }
                if (!this.protocolAuthService.enableAuth(secured = method.getAnnotation(Secured.class))) {
                    chain.doFilter(request, response);
                    return;
                }
                Resource resource = this.protocolAuthService.parseResource(req, secured);
                IdentityContext identityContext = this.protocolAuthService.parseIdentity(req);
                boolean result = this.protocolAuthService.validateIdentity(identityContext, resource);
                if (!result) {
                    throw new AccessException("Validate Identity failed.");
                }
                this.injectIdentityId(req, identityContext);
                String action = secured.action().toString();
                result = this.protocolAuthService.validateAuthority(identityContext, new Permission(resource, action));
                if (!result) {
                    throw new AccessException("Validate Authority failed.");
                }
            }
            chain.doFilter(request, response);
        }
        catch (AccessException e) {
            if (Loggers.AUTH.isDebugEnabled()) {
                Loggers.AUTH.debug("access denied, request: {} {}, reason: {}", new Object[]{req.getMethod(), req.getRequestURI(), e.getErrMsg()});
            }
            resp.sendError(403, e.getErrMsg());
        }
        catch (IllegalArgumentException e) {
            resp.sendError(400, ExceptionUtil.getAllExceptionMsg((Throwable)e));
        }
        catch (Exception e) {
            Loggers.AUTH.warn("[AUTH-FILTER] Server failed: ", (Throwable)e);
            resp.sendError(500, "Server failed, " + e.getMessage());
        }
    }

    private void injectIdentityId(HttpServletRequest request, IdentityContext identityContext) {
        String identityId = (String)identityContext.getParameter("identity_id", (Object)"");
        request.getSession().setAttribute("identity_id", (Object)identityId);
    }
}

