/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster;

import com.alibaba.nacos.api.ability.ServerAbilities;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.auth.util.AuthHeaderUtil;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.core.ability.ServerAbilityInitializer;
import com.alibaba.nacos.core.ability.ServerAbilityInitializerHolder;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberLookup;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.Task;
import com.alibaba.nacos.core.cluster.lookup.LookupFactory;
import com.alibaba.nacos.core.utils.GenericType;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component(value="serverMemberManager")
public class ServerMemberManager
implements ApplicationListener<WebServerInitializedEvent> {
    private final NacosAsyncRestTemplate asyncRestTemplate = HttpClientBeanHolder.getNacosAsyncRestTemplate((Logger)Loggers.CORE);
    private static final int DEFAULT_SERVER_PORT = 8848;
    private static final String SERVER_PORT_PROPERTY = "server.port";
    private static final String SPRING_MANAGEMENT_CONTEXT_NAMESPACE = "management";
    private static final String MEMBER_CHANGE_EVENT_QUEUE_SIZE_PROPERTY = "nacos.member-change-event.queue.size";
    private static final int DEFAULT_MEMBER_CHANGE_EVENT_QUEUE_SIZE = 128;
    private static boolean isUseAddressServer = false;
    private static final long DEFAULT_TASK_DELAY_TIME = 5000L;
    private volatile ConcurrentSkipListMap<String, Member> serverList;
    private static volatile boolean isInIpList = true;
    private int port;
    private String localAddress;
    private MemberLookup lookup;
    private volatile Member self;
    private volatile Set<String> memberAddressInfos = new ConcurrentHashSet();
    private final MemberInfoReportTask infoReportTask = new MemberInfoReportTask();

    public ServerMemberManager(ServletContext servletContext) throws Exception {
        this.serverList = new ConcurrentSkipListMap();
        EnvUtil.setContextPath((String)servletContext.getContextPath());
        this.init();
    }

    protected void init() throws NacosException {
        Loggers.CORE.info("Nacos-related cluster resource initialization");
        this.port = (Integer)EnvUtil.getProperty((String)SERVER_PORT_PROPERTY, Integer.class, (Object)8848);
        this.localAddress = InetUtils.getSelfIP() + ":" + this.port;
        this.self = MemberUtil.singleParse(this.localAddress);
        this.self.setExtendVal("version", VersionUtils.version);
        this.self.setAbilities(this.initMemberAbilities());
        this.serverList.put(this.self.getAddress(), this.self);
        this.registerClusterEvent();
        this.initAndStartLookup();
        if (this.serverList.isEmpty()) {
            throw new NacosException(500, "cannot get serverlist, so exit.");
        }
        Loggers.CORE.info("The cluster resource is initialized");
    }

    private ServerAbilities initMemberAbilities() {
        ServerAbilities serverAbilities = new ServerAbilities();
        for (ServerAbilityInitializer each : ServerAbilityInitializerHolder.getInstance().getInitializers()) {
            each.initialize(serverAbilities);
        }
        return serverAbilities;
    }

    private void registerClusterEvent() {
        NotifyCenter.registerToPublisher(MembersChangeEvent.class, (int)((Integer)EnvUtil.getProperty((String)MEMBER_CHANGE_EVENT_QUEUE_SIZE_PROPERTY, Integer.class, (Object)128)));
        NotifyCenter.registerSubscriber((Subscriber)new Subscriber<InetUtils.IPChangeEvent>(){

            public void onEvent(InetUtils.IPChangeEvent event) {
                String newAddress = event.getNewIP() + ":" + ServerMemberManager.this.port;
                ServerMemberManager.this.localAddress = newAddress;
                EnvUtil.setLocalAddress((String)ServerMemberManager.this.localAddress);
                Member self = ServerMemberManager.this.self;
                self.setIp(event.getNewIP());
                String oldAddress = event.getOldIP() + ":" + ServerMemberManager.this.port;
                ServerMemberManager.this.serverList.remove(oldAddress);
                ServerMemberManager.this.serverList.put(newAddress, self);
                ServerMemberManager.this.memberAddressInfos.remove(oldAddress);
                ServerMemberManager.this.memberAddressInfos.add(newAddress);
            }

            public Class<? extends Event> subscribeType() {
                return InetUtils.IPChangeEvent.class;
            }
        });
    }

    private void initAndStartLookup() throws NacosException {
        this.lookup = LookupFactory.createLookUp(this);
        isUseAddressServer = this.lookup.useAddressServer();
        this.lookup.start();
    }

    public void switchLookup(String name) throws NacosException {
        this.lookup = LookupFactory.switchLookup(name, this);
        isUseAddressServer = this.lookup.useAddressServer();
        this.lookup.start();
    }

    public static boolean isUseAddressServer() {
        return isUseAddressServer;
    }

    public boolean update(Member newMember) {
        Loggers.CLUSTER.debug("member information update : {}", (Object)newMember);
        String address = newMember.getAddress();
        if (!this.serverList.containsKey(address)) {
            Loggers.CLUSTER.warn("address {} want to update Member, but not in member list!", (Object)newMember.getAddress());
            return false;
        }
        this.serverList.computeIfPresent(address, (s, member) -> {
            if (NodeState.DOWN.equals((Object)newMember.getState())) {
                this.memberAddressInfos.remove(newMember.getAddress());
            }
            boolean isPublishChangeEvent = MemberUtil.isBasicInfoChanged(newMember, member);
            newMember.setExtendVal("lastRefreshTime", System.currentTimeMillis());
            MemberUtil.copy(newMember, member);
            if (isPublishChangeEvent) {
                this.notifyMemberChange((Member)member);
            }
            return member;
        });
        return true;
    }

    void notifyMemberChange(Member member) {
        NotifyCenter.publishEvent((Event)MembersChangeEvent.builder().trigger(member).members(this.allMembers()).build());
    }

    public boolean hasMember(String address) {
        boolean result = this.serverList.containsKey(address);
        if (result) {
            return true;
        }
        for (Map.Entry<String, Member> entry : this.serverList.entrySet()) {
            if (!StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)address)) continue;
            result = true;
            break;
        }
        return result;
    }

    public List<String> getServerListUnhealth() {
        ArrayList<String> unhealthyMembers = new ArrayList<String>();
        for (Member member : this.allMembers()) {
            NodeState state = member.getState();
            if (!state.equals((Object)NodeState.DOWN)) continue;
            unhealthyMembers.add(member.getAddress());
        }
        return unhealthyMembers;
    }

    public MemberLookup getLookup() {
        return this.lookup;
    }

    public Member getSelf() {
        return this.self;
    }

    public Member find(String address) {
        return this.serverList.get(address);
    }

    public Collection<Member> allMembers() {
        HashSet<Member> set = new HashSet<Member>(this.serverList.values());
        set.add(this.self);
        return set;
    }

    public List<Member> allMembersWithoutSelf() {
        ArrayList<Member> members = new ArrayList<Member>(this.serverList.values());
        members.remove(this.self);
        return members;
    }

    synchronized boolean memberChange(Collection<Member> members) {
        if (members == null || members.isEmpty()) {
            return false;
        }
        boolean isContainSelfIp = members.stream().anyMatch(ipPortTmp -> Objects.equals(this.localAddress, ipPortTmp.getAddress()));
        if (isContainSelfIp) {
            isInIpList = true;
        } else {
            isInIpList = false;
            members.add(this.self);
            Loggers.CLUSTER.warn("[serverlist] self ip {} not in serverlist {}", (Object)this.self, members);
        }
        boolean hasChange = members.size() != this.serverList.size();
        ConcurrentSkipListMap<String, Member> tmpMap = new ConcurrentSkipListMap<String, Member>();
        ConcurrentHashSet tmpAddressInfo = new ConcurrentHashSet();
        for (Member member : members) {
            String address = member.getAddress();
            Member existMember = this.serverList.get(address);
            if (existMember == null) {
                hasChange = true;
                tmpMap.put(address, member);
            } else {
                tmpMap.put(address, existMember);
            }
            if (!NodeState.UP.equals((Object)member.getState())) continue;
            tmpAddressInfo.add(address);
        }
        this.serverList = tmpMap;
        this.memberAddressInfos = tmpAddressInfo;
        Collection<Member> finalMembers = this.allMembers();
        if (hasChange) {
            Loggers.CLUSTER.warn("[serverlist] updated to : {}", finalMembers);
            MemberUtil.syncToFile(finalMembers);
            MembersChangeEvent event = MembersChangeEvent.builder().members(finalMembers).build();
            NotifyCenter.publishEvent((Event)event);
        } else if (Loggers.CLUSTER.isDebugEnabled()) {
            Loggers.CLUSTER.debug("[serverlist] not updated, is still : {}", finalMembers);
        }
        return hasChange;
    }

    public synchronized boolean memberJoin(Collection<Member> members) {
        HashSet<Member> set = new HashSet<Member>(members);
        set.addAll(this.allMembers());
        return this.memberChange(set);
    }

    public synchronized boolean memberLeave(Collection<Member> members) {
        HashSet<Member> set = new HashSet<Member>(this.allMembers());
        set.removeAll(members);
        return this.memberChange(set);
    }

    public boolean isUnHealth(String address) {
        Member member = this.serverList.get(address);
        if (member == null) {
            return false;
        }
        return !NodeState.UP.equals((Object)member.getState());
    }

    public boolean isFirstIp() {
        return Objects.equals(this.serverList.firstKey(), this.localAddress);
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        String serverNamespace = event.getApplicationContext().getServerNamespace();
        if (SPRING_MANAGEMENT_CONTEXT_NAMESPACE.equals(serverNamespace)) {
            return;
        }
        this.getSelf().setState(NodeState.UP);
        if (!EnvUtil.getStandaloneMode()) {
            GlobalExecutor.scheduleByCommon(this.infoReportTask, 5000L);
        }
        EnvUtil.setPort((int)event.getWebServer().getPort());
        EnvUtil.setLocalAddress((String)this.localAddress);
        Loggers.CLUSTER.info("This node is ready to provide external services");
    }

    @PreDestroy
    public void shutdown() throws NacosException {
        this.serverList.clear();
        this.memberAddressInfos.clear();
        this.infoReportTask.shutdown();
        LookupFactory.destroy();
    }

    public Set<String> getMemberAddressInfos() {
        return this.memberAddressInfos;
    }

    @JustForTest
    public void updateMember(Member member) {
        this.serverList.put(member.getAddress(), member);
    }

    @JustForTest
    public void setMemberAddressInfos(Set<String> memberAddressInfos) {
        this.memberAddressInfos = memberAddressInfos;
    }

    @JustForTest
    public MemberInfoReportTask getInfoReportTask() {
        return this.infoReportTask;
    }

    public Map<String, Member> getServerList() {
        return Collections.unmodifiableMap(this.serverList);
    }

    public static boolean isInIpList() {
        return isInIpList;
    }

    class MemberInfoReportTask
    extends Task {
        private final GenericType<RestResult<String>> reference = new GenericType<RestResult<String>>(){};
        private int cursor = 0;

        MemberInfoReportTask() {
        }

        @Override
        protected void executeBody() {
            List<Member> members = ServerMemberManager.this.allMembersWithoutSelf();
            if (members.isEmpty()) {
                return;
            }
            this.cursor = (this.cursor + 1) % members.size();
            final Member target = members.get(this.cursor);
            Loggers.CLUSTER.debug("report the metadata to the node : {}", (Object)target.getAddress());
            String url = HttpUtils.buildUrl((boolean)false, (String)target.getAddress(), (String[])new String[]{EnvUtil.getContextPath(), "/v1/core", "/cluster/report"});
            try {
                Header header = Header.newInstance().addParam("Nacos-Server", VersionUtils.version);
                AuthHeaderUtil.addIdentityToHeader((Header)header);
                ServerMemberManager.this.asyncRestTemplate.post(url, header, Query.EMPTY, (Object)ServerMemberManager.this.getSelf(), this.reference.getType(), (Callback)new Callback<String>(){

                    public void onReceive(RestResult<String> result) {
                        if (MemberInfoReportTask.this.isBelow13Version(result.getCode())) {
                            MemberInfoReportTask.this.handleBelow13Version(target);
                        }
                        if (result.ok()) {
                            MemberInfoReportTask.this.handleReportResult((String)result.getData(), target);
                        } else {
                            Loggers.CLUSTER.warn("failed to report new info to target node : {}, result : {}", (Object)target.getAddress(), result);
                            MemberUtil.onFail(ServerMemberManager.this, target);
                        }
                    }

                    public void onError(Throwable throwable) {
                        Loggers.CLUSTER.error("failed to report new info to target node : {}, error : {}", (Object)target.getAddress(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)throwable));
                        MemberUtil.onFail(ServerMemberManager.this, target, throwable);
                    }

                    public void onCancel() {
                    }
                });
            }
            catch (Throwable ex) {
                Loggers.CLUSTER.error("failed to report new info to target node : {}, error : {}", (Object)target.getAddress(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
            }
        }

        @Override
        protected void after() {
            GlobalExecutor.scheduleByCommon(this, 2000L);
        }

        private void handleReportResult(String reportResult, Member target) {
            if (this.isBooleanResult(reportResult)) {
                MemberUtil.onSuccess(ServerMemberManager.this, target);
                return;
            }
            try {
                Member member = (Member)JacksonUtils.toObj((String)reportResult, Member.class);
                MemberUtil.onSuccess(ServerMemberManager.this, target, member);
            }
            catch (Exception e) {
                Loggers.CLUSTER.warn("Receive invalid report result from target {}, context {}", (Object)target.getAddress(), (Object)reportResult);
                MemberUtil.onSuccess(ServerMemberManager.this, target);
            }
        }

        private boolean isBooleanResult(String reportResult) {
            return Boolean.TRUE.toString().equals(reportResult) || Boolean.FALSE.toString().equals(reportResult);
        }

        @Deprecated
        private boolean isBelow13Version(int code) {
            return HttpStatus.NOT_IMPLEMENTED.value() == code || HttpStatus.NOT_FOUND.value() == code;
        }

        @Deprecated
        private void handleBelow13Version(Member target) {
            Loggers.CLUSTER.warn("{} version is too low, it is recommended to upgrade the version : {}", (Object)target, (Object)VersionUtils.version);
            Member memberNew = null;
            if (target.getExtendVal("version") != null) {
                memberNew = target.copy();
                memberNew.delExtendVal("version");
                memberNew.delExtendVal("readyToUpgrade");
                Loggers.CLUSTER.warn("{} : Clean up version info, target has been downgrade to old version.", (Object)memberNew);
            }
            if (target.getAbilities() != null && target.getAbilities().getRemoteAbility() != null && target.getAbilities().getRemoteAbility().isSupportRemoteConnection()) {
                if (memberNew == null) {
                    memberNew = target.copy();
                }
                memberNew.getAbilities().getRemoteAbility().setSupportRemoteConnection(false);
                Loggers.CLUSTER.warn("{} : Clear support remote connection flag,target may rollback version ", (Object)memberNew);
            }
            if (memberNew != null) {
                ServerMemberManager.this.update(memberNew);
            }
        }
    }
}

