/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/core/ops"})
public class CoreOpsController {
    private final ProtocolManager protocolManager;
    private final IdGeneratorManager idGeneratorManager;

    public CoreOpsController(ProtocolManager protocolManager, IdGeneratorManager idGeneratorManager) {
        this.protocolManager = protocolManager;
        this.idGeneratorManager = idGeneratorManager;
    }

    @PostMapping(value={"/raft"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin")
    public RestResult<String> raftOps(@RequestBody Map<String, String> commands) {
        return this.protocolManager.getCpProtocol().execute(commands);
    }

    @GetMapping(value={"/idInfo"})
    public RestResult<Map<String, Map<Object, Object>>> idInfo() {
        HashMap info = new HashMap(10);
        this.idGeneratorManager.getGeneratorMap().forEach((resource, idGenerator) -> info.put(resource, idGenerator.info()));
        return RestResultUtils.success(info);
    }

    @PutMapping(value={"/log"})
    public String setLogLevel(@RequestParam String logName, @RequestParam String logLevel) {
        Loggers.setLogLevel(logName, logLevel);
        return "200";
    }
}

