/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.task.load;

import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.distro.DistroConfig;
import com.alibaba.nacos.core.distributed.distro.component.DistroCallback;
import com.alibaba.nacos.core.distributed.distro.component.DistroComponentHolder;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataProcessor;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DistroLoadDataTask
implements Runnable {
    private final ServerMemberManager memberManager;
    private final DistroComponentHolder distroComponentHolder;
    private final DistroConfig distroConfig;
    private final DistroCallback loadCallback;
    private final Map<String, Boolean> loadCompletedMap;

    public DistroLoadDataTask(ServerMemberManager memberManager, DistroComponentHolder distroComponentHolder, DistroConfig distroConfig, DistroCallback loadCallback) {
        this.memberManager = memberManager;
        this.distroComponentHolder = distroComponentHolder;
        this.distroConfig = distroConfig;
        this.loadCallback = loadCallback;
        this.loadCompletedMap = new HashMap<String, Boolean>(1);
    }

    @Override
    public void run() {
        try {
            this.load();
            if (!this.checkCompleted()) {
                GlobalExecutor.submitLoadDataTask(this, this.distroConfig.getLoadDataRetryDelayMillis());
            } else {
                this.loadCallback.onSuccess();
                Loggers.DISTRO.info("[DISTRO-INIT] load snapshot data success");
            }
        }
        catch (Exception e) {
            this.loadCallback.onFailed(e);
            Loggers.DISTRO.error("[DISTRO-INIT] load snapshot data failed. ", (Throwable)e);
        }
    }

    private void load() throws Exception {
        while (this.memberManager.allMembersWithoutSelf().isEmpty()) {
            Loggers.DISTRO.info("[DISTRO-INIT] waiting server list init...");
            TimeUnit.SECONDS.sleep(1L);
        }
        while (this.distroComponentHolder.getDataStorageTypes().isEmpty()) {
            Loggers.DISTRO.info("[DISTRO-INIT] waiting distro data storage register...");
            TimeUnit.SECONDS.sleep(1L);
        }
        for (String each : this.distroComponentHolder.getDataStorageTypes()) {
            if (this.loadCompletedMap.containsKey(each) && this.loadCompletedMap.get(each).booleanValue()) continue;
            this.loadCompletedMap.put(each, this.loadAllDataSnapshotFromRemote(each));
        }
    }

    private boolean loadAllDataSnapshotFromRemote(String resourceType) {
        DistroTransportAgent transportAgent = this.distroComponentHolder.findTransportAgent(resourceType);
        DistroDataProcessor dataProcessor = this.distroComponentHolder.findDataProcessor(resourceType);
        if (null == transportAgent || null == dataProcessor) {
            Loggers.DISTRO.warn("[DISTRO-INIT] Can't find component for type {}, transportAgent: {}, dataProcessor: {}", new Object[]{resourceType, transportAgent, dataProcessor});
            return false;
        }
        for (Member each : this.memberManager.allMembersWithoutSelf()) {
            long startTime = System.currentTimeMillis();
            try {
                Loggers.DISTRO.info("[DISTRO-INIT] load snapshot {} from {}", (Object)resourceType, (Object)each.getAddress());
                DistroData distroData = transportAgent.getDatumSnapshot(each.getAddress());
                Loggers.DISTRO.info("[DISTRO-INIT] it took {} ms to load snapshot {} from {} and snapshot size is {}.", new Object[]{System.currentTimeMillis() - startTime, resourceType, each.getAddress(), DistroLoadDataTask.getDistroDataLength(distroData)});
                boolean result = dataProcessor.processSnapshot(distroData);
                Loggers.DISTRO.info("[DISTRO-INIT] load snapshot {} from {} result: {}", new Object[]{resourceType, each.getAddress(), result});
                if (!result) continue;
                this.distroComponentHolder.findDataStorage(resourceType).finishInitial();
                return true;
            }
            catch (Exception e) {
                Loggers.DISTRO.error("[DISTRO-INIT] load snapshot {} from {} failed.", new Object[]{resourceType, each.getAddress(), e});
            }
        }
        return false;
    }

    private static int getDistroDataLength(DistroData distroData) {
        return distroData != null && distroData.getContent() != null ? distroData.getContent().length : 0;
    }

    private boolean checkCompleted() {
        if (this.distroComponentHolder.getDataStorageTypes().size() != this.loadCompletedMap.size()) {
            return false;
        }
        for (Boolean each : this.loadCompletedMap.values()) {
            if (each.booleanValue()) continue;
            return false;
        }
        return true;
    }
}

