/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.control;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.core.remote.AbstractRequestFilter;
import com.alibaba.nacos.core.remote.control.ClientIpMonitorKey;
import com.alibaba.nacos.core.remote.control.MonitorKey;
import com.alibaba.nacos.core.remote.control.MonitorKeyParser;
import com.alibaba.nacos.core.remote.control.TpsControl;
import com.alibaba.nacos.core.remote.control.TpsControlConfig;
import com.alibaba.nacos.core.remote.control.TpsMonitorManager;
import com.alibaba.nacos.core.utils.Loggers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TpsControlRequestFilter
extends AbstractRequestFilter {
    @Autowired
    private TpsMonitorManager tpsMonitorManager;

    @Override
    protected Response filter(Request request, RequestMeta meta, Class handlerClazz) {
        Method method = null;
        try {
            method = this.getHandleMethod(handlerClazz);
        }
        catch (NacosException e) {
            return null;
        }
        if (method.isAnnotationPresent(TpsControl.class) && TpsControlConfig.isTpsControlEnabled()) {
            boolean pass;
            TpsControl tpsControl = method.getAnnotation(TpsControl.class);
            String pointName = tpsControl.pointName();
            Class[] parsers = tpsControl.parsers();
            ArrayList<MonitorKey> monitorKeys = new ArrayList<MonitorKey>();
            monitorKeys.add(new ClientIpMonitorKey(meta.getClientIp()));
            if (parsers != null) {
                for (Class clazz : parsers) {
                    try {
                        MonitorKey parseKey;
                        if (!MonitorKeyParser.class.isAssignableFrom(clazz) || (parseKey = ((MonitorKeyParser)clazz.newInstance()).parse(request, meta)) == null) continue;
                        monitorKeys.add(parseKey);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (!(pass = this.tpsMonitorManager.applyTps(pointName, meta.getConnectionId(), monitorKeys))) {
                try {
                    Response response = super.getDefaultResponseInstance(handlerClazz);
                    response.setErrorInfo(503, "Tps Flow restricted");
                    return response;
                }
                catch (Exception e) {
                    Loggers.TPS_CONTROL_DETAIL.warn("Tps monitor fail , request: {},exception:{}", (Object)request.getClass().getSimpleName(), (Object)e);
                    return null;
                }
            }
        }
        return null;
    }
}

