/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.cluster.transport;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.cluster.transport.Serializer;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.pojo.Record;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class JacksonSerializer
implements Serializer {
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String KEY = "key";
    private static final String VALUE = "value";

    @Override
    public <T> byte[] serialize(T data) {
        return JacksonUtils.toJsonBytes(data);
    }

    @Override
    public <T> T deserialize(byte[] data, Class<T> clazz) {
        return (T)JacksonUtils.toObj((byte[])data, clazz);
    }

    @Override
    public <T extends Record> Map<String, Datum<T>> deserializeMap(byte[] data, Class<T> clazz) {
        HashMap resultMap;
        try {
            resultMap = (HashMap)JacksonUtils.toObj((byte[])data, (TypeReference)new TypeReference<Map<String, Datum<T>>>(){});
        }
        catch (Exception e) {
            Map dataMap = (Map)JacksonUtils.toObj((byte[])data, (TypeReference)new TypeReference<Map<String, JsonNode>>(){});
            resultMap = new HashMap(dataMap.size());
            for (Map.Entry entry : dataMap.entrySet()) {
                Datum datum = new Datum();
                datum.timestamp.set(((JsonNode)entry.getValue()).get(TIMESTAMP_KEY).asLong());
                datum.key = ((JsonNode)entry.getValue()).get(KEY).asText();
                datum.value = (Record)JacksonUtils.toObj((String)((JsonNode)entry.getValue()).get(VALUE).toString(), clazz);
                resultMap.put(entry.getKey(), datum);
            }
        }
        return resultMap;
    }
}

