/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.selector.Selector;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.DeregisterServiceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.RegisterServiceTraceEvent;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.NumberUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.ServiceOperatorV2Impl;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.ServiceDetailInfo;
import com.alibaba.nacos.naming.pojo.ServiceNameView;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.naming.selector.SelectorManager;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/ns/service"})
public class ServiceControllerV2 {
    private final ServiceOperatorV2Impl serviceOperatorV2;
    private final SelectorManager selectorManager;

    public ServiceControllerV2(ServiceOperatorV2Impl serviceOperatorV2, SelectorManager selectorManager) {
        this.serviceOperatorV2 = serviceOperatorV2;
        this.selectorManager = selectorManager;
    }

    @PostMapping(value={"/{serviceName}"})
    @Secured(action=ActionTypes.WRITE)
    public RestResult<String> create(@RequestParam(defaultValue="public") String namespaceId, @PathVariable String serviceName, @RequestParam(defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(required=false, defaultValue="false") boolean ephemeral, @RequestParam(required=false, defaultValue="0.0F") float protectThreshold, @RequestParam(defaultValue="") String metadata, @RequestParam(defaultValue="") String selector) throws Exception {
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(protectThreshold);
        serviceMetadata.setSelector(this.parseSelector(selector));
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata(metadata));
        serviceMetadata.setEphemeral(ephemeral);
        this.serviceOperatorV2.create(Service.newService(namespaceId, groupName, serviceName, ephemeral), serviceMetadata);
        NotifyCenter.publishEvent((Event)new RegisterServiceTraceEvent(System.currentTimeMillis(), namespaceId, groupName, serviceName));
        return RestResultUtils.success((Object)"ok");
    }

    @DeleteMapping(value={"/{serviceName}"})
    @Secured(action=ActionTypes.WRITE)
    public RestResult<String> remove(@RequestParam(defaultValue="public") String namespaceId, @PathVariable String serviceName, @RequestParam(defaultValue="DEFAULT_GROUP") String groupName) throws Exception {
        this.serviceOperatorV2.delete(Service.newService(namespaceId, groupName, serviceName));
        NotifyCenter.publishEvent((Event)new DeregisterServiceTraceEvent(System.currentTimeMillis(), namespaceId, groupName, serviceName));
        return RestResultUtils.success((Object)"ok");
    }

    @GetMapping(value={"/{serviceName}"})
    @Secured(action=ActionTypes.READ)
    public RestResult<ServiceDetailInfo> detail(@RequestParam(defaultValue="public") String namespaceId, @PathVariable String serviceName, @RequestParam(defaultValue="DEFAULT_GROUP") String groupName) throws Exception {
        ServiceDetailInfo result = this.serviceOperatorV2.queryService(Service.newService(namespaceId, groupName, serviceName));
        return RestResultUtils.success((Object)result);
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ)
    public RestResult<ServiceNameView> list(HttpServletRequest request) throws Exception {
        int pageNo = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageNo"));
        int pageSize = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageSize"));
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String groupName = WebUtils.optional((HttpServletRequest)request, (String)"groupName", (String)"DEFAULT_GROUP");
        String selectorString = WebUtils.optional((HttpServletRequest)request, (String)"selector", (String)"");
        ServiceNameView result = new ServiceNameView();
        Collection<String> serviceNameList = this.serviceOperatorV2.listService(namespaceId, groupName, selectorString);
        result.setCount(serviceNameList.size());
        result.setServices(ServiceUtil.pageServiceName(pageNo, pageSize, serviceNameList));
        return RestResultUtils.success((Object)result);
    }

    @PutMapping(value={"/{serviceName}"})
    @Secured(action=ActionTypes.WRITE)
    public RestResult<String> update(@RequestParam(defaultValue="public") String namespaceId, @PathVariable String serviceName, @RequestParam(defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(required=false, defaultValue="0.0F") float protectThreshold, @RequestParam(defaultValue="") String metadata, @RequestParam(defaultValue="") String selector) throws Exception {
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(protectThreshold);
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata(metadata));
        serviceMetadata.setSelector(this.parseSelector(selector));
        Service service = Service.newService(namespaceId, groupName, serviceName);
        this.serviceOperatorV2.update(service, serviceMetadata);
        return RestResultUtils.success((Object)"ok");
    }

    private Selector parseSelector(String selectorJsonString) throws Exception {
        String expression;
        if (StringUtils.isBlank((CharSequence)selectorJsonString)) {
            return new NoneSelector();
        }
        JsonNode selectorJson = JacksonUtils.toObj((String)URLDecoder.decode(selectorJsonString, "UTF-8"));
        String type = Optional.ofNullable(selectorJson.get("type")).orElseThrow(() -> new NacosException(400, "not match any type of selector!")).asText();
        Selector selector = this.selectorManager.parseSelector(type, expression = (String)Optional.ofNullable(selectorJson.get("expression")).map(JsonNode::asText).orElse(null));
        if (Objects.isNull(selector)) {
            throw new NacosException(400, "not match any type of selector!");
        }
        return selector;
    }
}

