/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteAction;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV1Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.HashMap;
import java.util.Map;

public class AsyncServicesCheckTask
extends AbstractExecuteTask {
    private final DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine;
    private final UpgradeJudgement upgradeJudgement;
    private static final int INITIALCAPACITY = 64;

    public AsyncServicesCheckTask(DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine, UpgradeJudgement upgradeJudgement) {
        this.doubleWriteDelayTaskEngine = doubleWriteDelayTaskEngine;
        this.upgradeJudgement = upgradeJudgement;
    }

    public void run() {
        if (this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        try {
            ServiceManager serviceManager = (ServiceManager)ApplicationUtils.getBean(ServiceManager.class);
            ServiceStorage serviceStorage = (ServiceStorage)ApplicationUtils.getBean(ServiceStorage.class);
            HashMap<String, Service> v1Services = new HashMap<String, Service>(64);
            for (String each : serviceManager.getAllNamespaces()) {
                for (Map.Entry<String, Service> entry : serviceManager.chooseServiceMap(each).entrySet()) {
                    v1Services.put(this.buildServiceKey(each, entry.getKey()), entry.getValue());
                    this.checkService(each, entry.getKey(), entry.getValue(), serviceStorage);
                }
            }
            HashMap<String, com.alibaba.nacos.naming.core.v2.pojo.Service> v2Services = new HashMap<String, com.alibaba.nacos.naming.core.v2.pojo.Service>(64);
            for (String each : com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().getAllNamespaces()) {
                for (com.alibaba.nacos.naming.core.v2.pojo.Service serviceV2 : com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().getSingletons(each)) {
                    v2Services.put(this.buildServiceKey(each, serviceV2.getGroupedServiceName()), serviceV2);
                }
            }
            v2Services.keySet().removeIf(v1Services::containsKey);
            if (v2Services.isEmpty()) {
                return;
            }
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("{} service in v2 to removed.", (Object)v2Services.size());
            }
            for (com.alibaba.nacos.naming.core.v2.pojo.Service service : v2Services.values()) {
                this.deleteV2Service(service);
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("async check for service error", (Throwable)e);
        }
    }

    private String buildServiceKey(String namespace, String fullServiceName) {
        return namespace + "##" + fullServiceName;
    }

    private void checkService(String namespace, String fullServiceName, Service serviceV1, ServiceStorage serviceStorage) {
        if (this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        String groupName = NamingUtils.getGroupName((String)serviceV1.getName());
        String serviceName = NamingUtils.getServiceName((String)fullServiceName);
        com.alibaba.nacos.naming.core.v2.pojo.Service serviceV2 = com.alibaba.nacos.naming.core.v2.pojo.Service.newService(namespace, groupName, serviceName);
        ServiceInfo serviceInfo = serviceStorage.getData(serviceV2);
        if (serviceV1.allIPs().size() != serviceInfo.getHosts().size()) {
            boolean isEphemeral = serviceV1.allIPs(false).isEmpty();
            String key = ServiceChangeV1Task.getKey(namespace, fullServiceName, isEphemeral);
            ServiceChangeV1Task task = new ServiceChangeV1Task(namespace, fullServiceName, isEphemeral, DoubleWriteContent.INSTANCE);
            this.doubleWriteDelayTaskEngine.addTask(key, task);
        }
    }

    private void deleteV2Service(com.alibaba.nacos.naming.core.v2.pojo.Service serviceV2) {
        if (this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        String namespace = serviceV2.getNamespace();
        String serviceName = serviceV2.getGroupedServiceName();
        boolean ephemeral = serviceV2.isEphemeral();
        String key = ServiceChangeV1Task.getKey(namespace, serviceName, ephemeral);
        ServiceChangeV1Task task = new ServiceChangeV1Task(namespace, serviceName, ephemeral, DoubleWriteContent.BOTH, DoubleWriteAction.REMOVE);
        this.doubleWriteDelayTaskEngine.addTask(key, task);
    }
}

