/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Http;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.healthcheck.HealthCheckCommon;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.misc.HttpClientManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import java.net.ConnectException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="httpHealthCheckProcessorV1")
public class HttpHealthCheckProcessor
implements HealthCheckProcessor {
    public static final String TYPE = "HTTP";
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private HealthCheckCommon healthCheckCommon;
    private static final NacosAsyncRestTemplate ASYNC_REST_TEMPLATE = HttpClientManager.getProcessorNacosAsyncRestTemplate();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void process(HealthCheckTask task) {
        List<Instance> ips = task.getCluster().allIPs(false);
        if (CollectionUtils.isEmpty(ips)) {
            return;
        }
        if (!this.switchDomain.isHealthCheckEnabled()) {
            return;
        }
        Cluster cluster = task.getCluster();
        for (Instance ip : ips) {
            try {
                if (ip.isMarked()) {
                    if (!Loggers.SRV_LOG.isDebugEnabled()) continue;
                    Loggers.SRV_LOG.debug("http check, ip is marked as to skip health check, ip: {}" + ip.getIp());
                    continue;
                }
                if (!ip.markChecking()) {
                    Loggers.SRV_LOG.warn("http check started before last one finished, service: {}:{}:{}", new Object[]{task.getCluster().getService().getName(), task.getCluster().getName(), ip.getIp()});
                    this.healthCheckCommon.reEvaluateCheckRT(task.getCheckRtNormalized() * 2L, task, this.switchDomain.getHttpHealthParams());
                    continue;
                }
                Http healthChecker = (Http)cluster.getHealthChecker();
                int ckPort = cluster.isUseIPPort4Check() ? ip.getPort() : cluster.getDefCkport();
                URL host = new URL("http://" + ip.getIp() + ":" + ckPort);
                URL target = new URL(host, healthChecker.getPath());
                Map customHeaders = healthChecker.getCustomHeaders();
                Header header = Header.newInstance();
                header.addAll(customHeaders);
                ASYNC_REST_TEMPLATE.get(target.toString(), header, Query.EMPTY, String.class, (Callback)new HttpHealthCheckCallback(ip, task));
                MetricsMonitor.getHttpHealthCheckMonitor().incrementAndGet();
            }
            catch (Throwable e) {
                ip.setCheckRt(this.switchDomain.getHttpHealthParams().getMax());
                this.healthCheckCommon.checkFail(ip, task, "http:error:" + e.getMessage());
                this.healthCheckCommon.reEvaluateCheckRT(this.switchDomain.getHttpHealthParams().getMax(), task, this.switchDomain.getHttpHealthParams());
            }
        }
    }

    private class HttpHealthCheckCallback
    implements Callback<String> {
        private Instance ip;
        private HealthCheckTask task;
        private long startTime = System.currentTimeMillis();

        public HttpHealthCheckCallback(Instance ip, HealthCheckTask task) {
            this.ip = ip;
            this.task = task;
        }

        public void onReceive(RestResult<String> result) {
            this.ip.setCheckRt(System.currentTimeMillis() - this.startTime);
            int httpCode = result.getCode();
            if (200 == httpCode) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkOK(this.ip, this.task, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(System.currentTimeMillis() - this.startTime, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else if (503 == httpCode || 302 == httpCode) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(this.task.getCheckRtNormalized() * 2L, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.ip, this.task, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            }
        }

        public void onError(Throwable t) {
            this.ip.setCheckRt(System.currentTimeMillis() - this.startTime);
            Throwable cause = t;
            int maxStackDepth = 50;
            for (int deepth = 0; deepth < maxStackDepth && cause != null; cause = cause.getCause(), ++deepth) {
                if (!HttpUtils.isTimeoutException((Throwable)t)) continue;
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "http:timeout:" + cause.getMessage());
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(this.task.getCheckRtNormalized() * 2L, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
                return;
            }
            if (t instanceof ConnectException) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.ip, this.task, "http:unable2connect:" + t.getMessage());
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "http:error:" + t.getMessage());
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            }
        }

        public void onCancel() {
        }
    }
}

