/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.utils;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DistroUtils {
    public static String serviceKey(Service service) {
        return service.getNamespace() + "##" + service.getGroupedServiceName() + "##" + service.isEphemeral();
    }

    public static int stringHash(Client client) {
        String s = DistroUtils.buildUniqueString(client);
        if (s == null) {
            return 0;
        }
        return s.hashCode();
    }

    public static int hash(Client client) {
        if (!(client instanceof IpPortBasedClient)) {
            return 0;
        }
        return Objects.hash(client.getClientId(), client.getAllPublishedService().stream().map(s -> {
            InstancePublishInfo ip = client.getInstancePublishInfo((Service)s);
            double weight = DistroUtils.getWeight(ip);
            Boolean enabled = DistroUtils.getEnabled(ip);
            String cluster = StringUtils.defaultIfBlank((String)ip.getCluster(), (String)"DEFAULT");
            return Objects.hash(s.getNamespace(), s.getGroup(), s.getName(), s.isEphemeral(), ip.getIp(), ip.getPort(), weight, ip.isHealthy(), enabled, cluster, ip.getExtendDatum());
        }).collect(Collectors.toSet()));
    }

    public static String checksum(Client client) {
        String s = DistroUtils.buildUniqueString(client);
        if (s == null) {
            return "0";
        }
        return MD5Utils.md5Hex((String)s, (String)"UTF-8");
    }

    public static String buildUniqueString(Client client) {
        if (!(client instanceof IpPortBasedClient)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(client.getClientId()).append('|');
        client.getAllPublishedService().stream().sorted(Comparator.comparing(DistroUtils::serviceKey)).forEach(s -> {
            InstancePublishInfo ip = client.getInstancePublishInfo((Service)s);
            double weight = DistroUtils.getWeight(ip);
            Boolean enabled = DistroUtils.getEnabled(ip);
            String cluster = StringUtils.defaultIfBlank((String)ip.getCluster(), (String)"DEFAULT");
            sb.append(DistroUtils.serviceKey(s)).append('_').append(ip.getIp()).append(':').append(ip.getPort()).append('_').append(weight).append('_').append(ip.isHealthy()).append('_').append(enabled).append('_').append(cluster).append('_').append(DistroUtils.convertMap2String(ip.getExtendDatum())).append(',');
        });
        return sb.toString();
    }

    private static boolean getEnabled(InstancePublishInfo ip) {
        Object enabled0 = ip.getExtendDatum().get("publishInstanceEnable");
        if (!(enabled0 instanceof Boolean)) {
            return true;
        }
        return (Boolean)enabled0;
    }

    private static double getWeight(InstancePublishInfo ip) {
        Object weight0 = ip.getExtendDatum().get("publishInstanceWeight");
        if (!(weight0 instanceof Number)) {
            return 1.0;
        }
        return ((Number)weight0).doubleValue();
    }

    private static String convertMap2String(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key);
            sb.append(':');
            sb.append(map.get(key));
            sb.append(',');
        }
        return sb.toString();
    }
}

