/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.validator.impl;

import cloud.tianai.captcha.common.AnyMap;
import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.common.response.ApiResponseStatusConstant;
import cloud.tianai.captcha.common.util.CaptchaTypeClassifier;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.validator.ImageCaptchaValidator;
import cloud.tianai.captcha.validator.SliderCaptchaPercentageValidator;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleImageCaptchaValidator
implements ImageCaptchaValidator,
SliderCaptchaPercentageValidator {
    private static final Logger log = LoggerFactory.getLogger(SimpleImageCaptchaValidator.class);
    public static float DEFAULT_TOLERANT = 0.02f;
    public static final String PERCENTAGE_KEY = "percentage";
    public static final String TOLERANT_KEY = "tolerant";
    public static final String TYPE_KEY = "type";
    public static final String USER_CURRENT_PERCENTAGE_STD = "user_current_percentage_std";
    public static final String USER_CURRENT_PERCENTAGE = "user_current_percentage";
    public float defaultTolerant = DEFAULT_TOLERANT;

    public SimpleImageCaptchaValidator() {
        CaptchaTypeClassifier.addSliderCaptchaType("CONCAT");
        CaptchaTypeClassifier.addSliderCaptchaType("ROTATE");
        CaptchaTypeClassifier.addSliderCaptchaType("SLIDER");
        CaptchaTypeClassifier.addClickCaptchaType("WORD_IMAGE_CLICK");
    }

    public SimpleImageCaptchaValidator(float defaultTolerant) {
        this();
        this.defaultTolerant = defaultTolerant;
    }

    @Override
    public float calcPercentage(Number pos, Number maxPos) {
        return pos.floatValue() / maxPos.floatValue();
    }

    @Override
    public boolean checkPercentage(Float newPercentage, Float oriPercentage) {
        return this.checkPercentage(newPercentage, oriPercentage, this.defaultTolerant);
    }

    @Override
    public boolean checkPercentage(Float newPercentage, Float oriPercentage, float tolerant) {
        if (newPercentage == null || Float.isNaN(newPercentage.floatValue()) || Float.isInfinite(newPercentage.floatValue()) || oriPercentage == null || Float.isNaN(oriPercentage.floatValue()) || Float.isInfinite(oriPercentage.floatValue())) {
            return false;
        }
        float maxTolerant = oriPercentage.floatValue() + tolerant;
        float minTolerant = oriPercentage.floatValue() - tolerant;
        return newPercentage.floatValue() >= minTolerant && newPercentage.floatValue() <= maxTolerant;
    }

    @Override
    public AnyMap generateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo) {
        AnyMap map = AnyMap.of(new HashMap<String, Object>(8));
        if (this.beforeGenerateImageCaptchaValidData(imageCaptchaInfo, map)) {
            this.doGenerateImageCaptchaValidData(map, imageCaptchaInfo);
        }
        this.afterGenerateImageCaptchaValidData(imageCaptchaInfo, map);
        return map;
    }

    public boolean beforeGenerateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo, AnyMap map) {
        String type;
        Float tolerant = imageCaptchaInfo.getTolerant();
        if (tolerant != null && tolerant.floatValue() > 0.0f) {
            map.put(TOLERANT_KEY, (Object)tolerant);
        }
        if (ObjectUtils.isEmpty(type = imageCaptchaInfo.getType())) {
            type = "SLIDER";
        }
        map.put(TYPE_KEY, (Object)type);
        return true;
    }

    public void afterGenerateImageCaptchaValidData(ImageCaptchaInfo imageCaptchaInfo, AnyMap map) {
    }

    public void doGenerateImageCaptchaValidData(AnyMap map, ImageCaptchaInfo imageCaptchaInfo) {
        Object expand;
        String type = (String)map.getOrDefault((Object)TYPE_KEY, "SLIDER");
        Object object = expand = imageCaptchaInfo.getData() == null ? null : imageCaptchaInfo.getData().getExpand();
        if (CaptchaTypeClassifier.isSliderCaptcha(type)) {
            this.addPercentage(imageCaptchaInfo, map);
        } else if (CaptchaTypeClassifier.isClickCaptcha(type)) {
            List clickImageCheckDefinitionList;
            if (expand == null) {
                throw new IllegalArgumentException("\u70b9\u9009\u9a8c\u8bc1\u7801\u6269\u5c55\u6570\u636e\u8f6c\u6362\u4e3a List<ClickImageCheckDefinition> \u5931\u8d25\uff0c info=" + imageCaptchaInfo);
            }
            try {
                clickImageCheckDefinitionList = (List)expand;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u70b9\u9009\u9a8c\u8bc1\u7801\u6269\u5c55\u6570\u636e\u8f6c\u6362\u4e3a List<ClickImageCheckDefinition> \u5931\u8d25\uff0c info=" + imageCaptchaInfo);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < clickImageCheckDefinitionList.size(); ++i) {
                ClickImageCheckDefinition definition = (ClickImageCheckDefinition)clickImageCheckDefinitionList.get(i);
                Integer x = definition.getX();
                Integer y = definition.getY();
                Integer width = imageCaptchaInfo.getBackgroundImageWidth();
                Integer height = imageCaptchaInfo.getBackgroundImageHeight();
                float vx = this.calcPercentage(x, width);
                float vy = this.calcPercentage(y, height);
                sb.append(vx).append(",").append(vy).append(";");
                if (i != 0 || map.containsKey(TOLERANT_KEY)) continue;
                float minLeft = this.calcPercentage(Float.valueOf((float)x.intValue() - (float)definition.getWidth().intValue() / 2.0f), width);
                float tolerant = vx - minLeft;
                map.put(TOLERANT_KEY, (Object)Float.valueOf(tolerant));
            }
            map.put(PERCENTAGE_KEY, (Object)sb.toString());
        } else if (CaptchaTypeClassifier.isJigsawCaptcha(type)) {
            map.put(PERCENTAGE_KEY, expand);
        }
    }

    @Override
    public ApiResponse<?> valid(ImageCaptchaTrack imageCaptchaTrack, AnyMap imageCaptchaValidData) {
        String type;
        Float tolerant = imageCaptchaValidData.getFloat(TOLERANT_KEY, Float.valueOf(this.defaultTolerant));
        ApiResponse<?> beforeValid = this.beforeValid(imageCaptchaTrack, imageCaptchaValidData, tolerant, type = imageCaptchaValidData.getString(TYPE_KEY, "SLIDER"));
        if (!beforeValid.isSuccess()) {
            return beforeValid;
        }
        Integer bgImageWidth = imageCaptchaTrack.getBgImageWidth();
        if (bgImageWidth == null || bgImageWidth < 1) {
            return ApiResponse.ofCheckError("\u9a8c\u8bc1\u7801\u80cc\u666f\u56fe\u7247\u5bbd\u5ea6\u53c2\u6570\u9519\u8bef");
        }
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        if (CollectionUtils.isEmpty(trackList)) {
            return ApiResponse.ofCheckError("\u6ca1\u6709\u89e3\u6790\u5230\u6ed1\u52a8\u8f68\u8ff9");
        }
        boolean valid = this.doValid(imageCaptchaTrack, imageCaptchaValidData, tolerant, type);
        return this.afterValid(valid, imageCaptchaTrack, imageCaptchaValidData, tolerant, type);
    }

    public ApiResponse<?> beforeValid(ImageCaptchaTrack imageCaptchaTrack, AnyMap captchaValidData, Float tolerant, String type) {
        return ApiResponse.ofSuccess();
    }

    public ApiResponse<?> afterValid(Boolean basicValid, ImageCaptchaTrack imageCaptchaTrack, AnyMap captchaValidData, Float tolerant, String type) {
        if (!basicValid.booleanValue()) {
            return ApiResponse.ofMessage(ApiResponseStatusConstant.BASIC_CHECK_FAIL);
        }
        return ApiResponse.ofSuccess();
    }

    public boolean doValid(ImageCaptchaTrack imageCaptchaTrack, AnyMap imageCaptchaValidData, Float tolerant, String type) {
        if (CaptchaTypeClassifier.isSliderCaptcha(type)) {
            return this.doValidSliderCaptcha(imageCaptchaTrack, imageCaptchaValidData, tolerant, type);
        }
        if (CaptchaTypeClassifier.isClickCaptcha(type)) {
            return this.doValidClickCaptcha(imageCaptchaTrack, imageCaptchaValidData, tolerant, type);
        }
        if (CaptchaTypeClassifier.isJigsawCaptcha(type)) {
            return this.doValidJigsawCaptcha(imageCaptchaTrack, imageCaptchaValidData, tolerant, type);
        }
        log.warn("\u6821\u9a8c\u9a8c\u8bc1\u7801\u8b66\u544a\uff0c \u4e0d\u652f\u6301\u7684\u9a8c\u8bc1\u7801\u7c7b\u578b:{}, \u8bf7\u624b\u52a8\u6269\u5c55 cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator.doValid \u8fdb\u884c\u6821\u9a8c\u6269\u5c55", (Object)type);
        return false;
    }

    public boolean doValidJigsawCaptcha(ImageCaptchaTrack imageCaptchaTrack, AnyMap imageCaptchaValidData, Float tolerant, String type) {
        if (imageCaptchaTrack.getData() == null || !(imageCaptchaTrack.getData() instanceof String)) {
            throw new IllegalArgumentException("\u62fc\u56fe\u9a8c\u8bc1\u7801\u5fc5\u987b\u4f20data\u6570\u636e\uff0c\u4e14\u5fc5\u987b\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\u9017\u53f7\u5206\u9694\u6570\u636e");
        }
        String posArr = (String)imageCaptchaTrack.getData();
        String successPosStr = imageCaptchaValidData.getString(PERCENTAGE_KEY, null);
        return successPosStr.equals(posArr);
    }

    public boolean doValidClickCaptcha(ImageCaptchaTrack imageCaptchaTrack, AnyMap imageCaptchaValidData, Float tolerant, String type) {
        String validStr = imageCaptchaValidData.getString(PERCENTAGE_KEY, null);
        if (ObjectUtils.isEmpty(validStr)) {
            return false;
        }
        String[] splitArr = validStr.split(";");
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        if (trackList.size() < splitArr.length) {
            return false;
        }
        List clickTrackList = trackList.stream().filter(t -> "CLICK".equalsIgnoreCase(t.getType())).collect(Collectors.toList());
        if (clickTrackList.size() != splitArr.length) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Double> percentages = new ArrayList<Double>();
        for (int i = 0; i < splitArr.length; ++i) {
            ImageCaptchaTrack.Track track = (ImageCaptchaTrack.Track)clickTrackList.get(i);
            String posStr = splitArr[i];
            String[] posArr = posStr.split(",");
            float xPercentage = Float.parseFloat(posArr[0]);
            float yPercentage = Float.parseFloat(posArr[1]);
            float calcXPercentage = this.calcPercentage(track.getX(), imageCaptchaTrack.getBgImageWidth());
            float calcYPercentage = this.calcPercentage(track.getY(), imageCaptchaTrack.getBgImageHeight());
            if (!this.checkPercentage(Float.valueOf(calcXPercentage), Float.valueOf(xPercentage), tolerant.floatValue()) || !this.checkPercentage(Float.valueOf(calcYPercentage), Float.valueOf(yPercentage), tolerant.floatValue())) {
                return false;
            }
            if (i > 0) {
                sb.append("|");
            }
            sb.append(calcXPercentage).append(",").append(calcYPercentage);
            percentages.add(Double.valueOf(calcXPercentage - xPercentage + (calcYPercentage - yPercentage)));
        }
        return true;
    }

    public boolean doValidSliderCaptcha(ImageCaptchaTrack imageCaptchaTrack, AnyMap imageCaptchaValidData, Float tolerant, String type) {
        Float oriPercentage = imageCaptchaValidData.getFloat(PERCENTAGE_KEY);
        if (oriPercentage == null) {
            return false;
        }
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        ImageCaptchaTrack.Track firstTrack = trackList.get(0);
        ImageCaptchaTrack.Track lastTrack = trackList.get(trackList.size() - 1);
        float calcPercentage = this.calcPercentage(Float.valueOf(lastTrack.getX().floatValue() - firstTrack.getX().floatValue()), imageCaptchaTrack.getBgImageWidth());
        boolean percentage = this.checkPercentage(Float.valueOf(calcPercentage), oriPercentage, tolerant.floatValue());
        if (percentage) {
            imageCaptchaValidData.put(USER_CURRENT_PERCENTAGE, (Object)String.valueOf(calcPercentage));
            imageCaptchaValidData.put(USER_CURRENT_PERCENTAGE_STD, (Object)String.valueOf(calcPercentage - oriPercentage.floatValue()));
        }
        return percentage;
    }

    protected void addPercentage(ImageCaptchaInfo imageCaptchaInfo, AnyMap imageCaptchaValidData) {
        float percentage = this.calcPercentage(imageCaptchaInfo.getRandomX(), imageCaptchaInfo.getBackgroundImageWidth());
        imageCaptchaValidData.put(PERCENTAGE_KEY, (Object)Float.valueOf(percentage));
    }

    public float getDefaultTolerant() {
        return this.defaultTolerant;
    }

    public void setDefaultTolerant(float defaultTolerant) {
        this.defaultTolerant = defaultTolerant;
    }
}

