/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtilClient {
    private static final Integer TIME_OUT = 300000;

    public static String sendGet(String url, Map<String, String> params, Map<String, String> header) throws Exception {
        HttpGet httpGet = null;
        String body = "";
        try {
            CloseableHttpResponse response;
            int n;
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(HttpUtilClient.getRequestConfig()).build();
            ArrayList<String> mapList = new ArrayList<String>();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    mapList.add(entry.getKey() + "=" + entry.getValue());
                }
            }
            if (!mapList.isEmpty()) {
                url = url + "?";
                String paramsStr = String.join((CharSequence)"&", mapList);
                url = url + (String)paramsStr;
            }
            httpGet = new HttpGet(url);
            httpGet.setHeader("Content-type", "application/json; charset=utf-8");
            httpGet.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            if (header != null) {
                for (Map.Entry entry : header.entrySet()) {
                    httpGet.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((n = (response = httpClient.execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode()) != 200) {
                throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25");
            }
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
        return body;
    }

    public static String sendPostJson(String url, String json) throws Exception {
        return HttpUtilClient.sendPostJson(url, json, null);
    }

    public static String sendPostJson(String url, String json, Map<String, String> header) throws Exception {
        HttpPost httpPost = null;
        String body = "";
        try {
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(HttpUtilClient.getRequestConfig()).build();
            httpPost = new HttpPost(url);
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity entity = new StringEntity(json, Charset.forName("UTF-8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25");
            }
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return body;
    }

    public static String sendPostForm(String url, Map<String, String> params) throws Exception {
        return HttpUtilClient.sendPostForm(url, params, null);
    }

    public static String sendPostForm(String url, Map<String, String> params, Map<String, String> header) throws Exception {
        HttpPost httpPost = null;
        String body = "";
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpPost = new HttpPost(url);
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    nameValuePairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n != 200) {
                throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25");
            }
            body = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return body;
    }

    private static RequestConfig getRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(TIME_OUT.intValue()).build();
        return requestConfig;
    }
}

