/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.template;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.sign.SaSignManager;
import cn.dev33.satoken.sign.config.SaSignConfig;
import cn.dev33.satoken.sign.template.SaSignTemplate;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoClientConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.message.handle.client.SaSsoMessageLogoutCallHandle;
import cn.dev33.satoken.sso.strategy.SaSsoClientStrategy;
import cn.dev33.satoken.sso.template.SaSsoTemplate;
import cn.dev33.satoken.stp.parameter.SaLogoutParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.Map;

public class SaSsoClientTemplate
extends SaSsoTemplate {
    public SaSsoClientStrategy strategy = new SaSsoClientStrategy();

    public SaSsoClientTemplate() {
        this.messageHolder.addHandle(new SaSsoMessageLogoutCallHandle());
    }

    public Object getData(Map<String, Object> paramMap) {
        String getDataUrl = this.getClientConfig().splicingGetDataUrl();
        return this.getData(getDataUrl, paramMap);
    }

    public Object getData(String path, Map<String, Object> paramMap) {
        String url = this.buildCustomPathUrl(path, paramMap);
        return this.strategy.sendRequest.apply(url);
    }

    public String buildGetDataUrl(Map<String, Object> paramMap) {
        String getDataUrl = this.getClientConfig().getGetDataUrl();
        return this.buildCustomPathUrl(getDataUrl, paramMap);
    }

    public String buildCustomPathUrl(String path, Map<String, Object> paramMap) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        String url = path;
        if (!url.startsWith("http")) {
            String serverUrl = ssoConfig.getServerUrl();
            SaSsoException.notEmpty(serverUrl, "\u8bf7\u5148\u914d\u7f6e sa-token.sso-client.server-url \u5730\u5740", 30012);
            url = SaFoxUtil.spliceTwoUrl((String)serverUrl, (String)path);
        }
        paramMap.put(this.paramName.client, this.getClient());
        String signParamsStr = this.getSignTemplate().addSignParamsAndJoin(paramMap);
        return SaFoxUtil.joinParam((String)url, (String)signParamsStr);
    }

    public String buildServerAuthUrl(String clientLoginUrl, String back) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        String serverUrl = ssoConfig.splicingAuthUrl();
        String client = this.getClient();
        if (SaFoxUtil.isNotEmpty((Object)client)) {
            serverUrl = SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.client, (Object)client);
        }
        back = back == null ? "" : back;
        back = SaFoxUtil.encodeUrl((String)back);
        if (!clientLoginUrl.contains(this.paramName.back + "=")) {
            clientLoginUrl = SaFoxUtil.joinParam((String)clientLoginUrl, (String)this.paramName.back, (Object)back);
        }
        return SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.redirect, (Object)clientLoginUrl);
    }

    public String pushMessage(SaSsoMessage message) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        String pushUrl = ssoConfig.splicingPushUrl();
        SaSsoException.notTrue(!SaFoxUtil.isUrl((String)pushUrl), "\u65e0\u6548 push-url \u5730\u5740\uff1a" + pushUrl, 30023);
        message.set(this.paramName.client, this.getClient());
        message.checkType();
        String paramsStr = this.getSignTemplate().addSignParamsAndJoin((Map)message);
        String finalUrl = SaFoxUtil.joinParam((String)pushUrl, (String)paramsStr);
        return (String)this.strategy.sendRequest.apply(finalUrl);
    }

    public SaResult pushMessageAsSaResult(SaSsoMessage message) {
        String res = this.pushMessage(message);
        Map map = SaManager.getSaJsonTemplate().jsonToMap(res);
        return new SaResult(map);
    }

    public SaSsoMessage buildCheckTicketMessage(String ticket, String ssoLogoutCallUrl) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        SaSsoMessage message = new SaSsoMessage();
        message.setType("checkTicket");
        message.set(this.paramName.client, this.getClient());
        message.set(this.paramName.ticket, ticket);
        message.set(this.paramName.ssoLogoutCall, ssoLogoutCallUrl);
        return message;
    }

    public SaSsoMessage buildSignoutMessage(Object loginId, SaLogoutParameter logoutParameter) {
        SaSsoMessage message = new SaSsoMessage();
        message.setType("signout");
        message.set(this.paramName.client, this.getClient());
        message.set(this.paramName.loginId, loginId);
        message.set(this.paramName.deviceId, logoutParameter.getDeviceId());
        return message;
    }

    public SaSsoClientConfig getClientConfig() {
        return SaSsoManager.getClientConfig();
    }

    public String getClient() {
        return this.getClientConfig().getClient();
    }

    public SaSignTemplate getSignTemplate() {
        SaSignConfig signConfig = SaSignManager.getSaSignTemplate().getSignConfigOrGlobal().copy();
        String secretKey = this.getClientConfig().getSecretKey();
        if (SaFoxUtil.isEmpty((Object)secretKey)) {
            secretKey = signConfig.getSecretKey();
        }
        signConfig.setSecretKey(secretKey);
        return new SaSignTemplate(signConfig);
    }
}

