/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.dialect.jdk;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.log.dialect.AbstractLog;
import com.aizuda.snailjob.common.log.factory.LogFactory;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JdkLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public JdkLog(Logger logger) {
        this.logger = logger;
    }

    public JdkLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public JdkLog(String name) {
        this(Logger.getLogger(name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.FINEST, fqcn, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.FINE, fqcn, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.INFO, fqcn, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.WARNING, fqcn, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.SEVERE, fqcn, format, arguments);
    }

    @Override
    public void log(com.aizuda.snailjob.common.log.level.Level level, Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(switch (level) {
            case com.aizuda.snailjob.common.log.level.Level.TRACE -> Level.FINEST;
            case com.aizuda.snailjob.common.log.level.Level.DEBUG -> Level.FINE;
            case com.aizuda.snailjob.common.log.level.Level.INFO -> Level.INFO;
            case com.aizuda.snailjob.common.log.level.Level.WARN -> Level.WARNING;
            case com.aizuda.snailjob.common.log.level.Level.ERROR -> Level.SEVERE;
            default -> throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        }, fqcn, format, arguments);
    }

    private void logIfEnabled(Level level, String callerFQCN, String format, Object ... arguments) {
        if (this.logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, StrUtil.format((CharSequence)format, (Object[])arguments));
            record.setLoggerName(this.getName());
            record.setThrown(LogFactory.extractThrowable(arguments));
            JdkLog.fillCallerData(callerFQCN, record);
            this.logger.log(record);
        }
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = Thread.currentThread().getStackTrace();
        int found = -1;
        for (int i = steArray.length - 2; i > -1; --i) {
            String className = steArray[i].getClassName();
            if (!callerFQCN.equals(className)) continue;
            found = i;
            break;
        }
        if (found > -1) {
            StackTraceElement ste = steArray[found + 1];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }
}

