/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.handler;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.ClientLoadBalance;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceManager;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ClientNodeAllocateHandler {
    public RegisterNodeInfo getServerNode(String allocKey, String groupName, String namespaceId, Integer routeKey) {
        Set<RegisterNodeInfo> serverNodes = CacheRegisterTable.getServerNodeSet(groupName, namespaceId);
        if (CollUtil.isEmpty(serverNodes)) {
            SnailJobLog.LOCAL.warn("client node is null. groupName:[{}]", new Object[]{groupName});
            return null;
        }
        ClientLoadBalance clientLoadBalanceRandom = ClientLoadBalanceManager.getClientLoadBalance(routeKey);
        String hostId = clientLoadBalanceRandom.route(allocKey, new TreeSet<String>(StreamUtils.toSet(serverNodes, RegisterNodeInfo::getHostId)));
        Stream<RegisterNodeInfo> registerNodeInfoStream = serverNodes.stream().filter(s -> s.getHostId().equals(hostId));
        return registerNodeInfoStream.findFirst().orElse(null);
    }

    @Generated
    public ClientNodeAllocateHandler() {
    }
}

