/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.generator.task;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.generator.task.AbstractJobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterTaskGenerator
extends AbstractJobTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(ClusterTaskGenerator.class);
    @Autowired
    protected ClientNodeAllocateHandler clientNodeAllocateHandler;
    @Autowired
    private JobTaskMapper jobTaskMapper;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.CLUSTER;
    }

    @Override
    public List<JobTask> doGenerate(JobTaskGenerateContext context) {
        RegisterNodeInfo serverNode = this.clientNodeAllocateHandler.getServerNode(context.getJobId().toString(), context.getGroupName(), context.getNamespaceId(), context.getRouteKey());
        if (Objects.isNull(serverNode)) {
            log.error("\u65e0\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef\u4fe1\u606f. jobId:[{}]", (Object)context.getJobId());
            return Lists.newArrayList();
        }
        JobTask jobTask = JobTaskConverter.INSTANCE.toJobTaskInstance(context);
        jobTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)serverNode));
        jobTask.setArgsType(context.getArgsType());
        jobTask.setArgsStr(context.getArgsStr());
        jobTask.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.RUNNING.getStatus()));
        jobTask.setResultMessage(Optional.ofNullable(jobTask.getResultMessage()).orElse(""));
        Assert.isTrue((1 == this.jobTaskMapper.insert((Object)jobTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u4efb\u52a1\u5b9e\u4f8b\u5931\u8d25"));
        return Lists.newArrayList((Object[])new JobTask[]{jobTask});
    }
}

