/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.starter.schedule;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OfflineNodeSchedule
extends AbstractSchedule
implements Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OfflineNodeSchedule.class);
    private final ServerNodeMapper serverNodeMapper;

    protected void doExecute() {
        try {
            Set allPods;
            Set waitOffline;
            Set podIds;
            LocalDateTime endTime = LocalDateTime.now().minusSeconds(40L);
            List serverNodes = this.serverNodeMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ServerNode::getId}).le(ServerNode::getExpireAt, (Object)endTime));
            if (CollUtil.isNotEmpty((Collection)serverNodes)) {
                this.serverNodeMapper.deleteByIds((Collection)StreamUtils.toSet((Collection)serverNodes, ServerNode::getId));
            }
            if (CollUtil.isEmpty((Collection)(podIds = StreamUtils.toSet(waitOffline = (allPods = CacheRegisterTable.getAllPods()).stream().filter(registerNodeInfo -> registerNodeInfo.getExpireAt().isBefore(endTime)).collect(Collectors.toSet()), RegisterNodeInfo::getHostId)))) {
                return;
            }
            for (RegisterNodeInfo registerNodeInfo2 : waitOffline) {
                CacheRegisterTable.remove((String)registerNodeInfo2.getGroupName(), (String)registerNodeInfo2.getNamespaceId(), (String)registerNodeInfo2.getHostId());
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Clear offline node failed", new Object[]{e});
        }
    }

    public String lockName() {
        return "clearOfflineNode";
    }

    public String lockAtMost() {
        return "PT10S";
    }

    public String lockAtLeast() {
        return "PT5S";
    }

    public void start() {
        this.taskScheduler.scheduleWithFixedDelay(() -> ((OfflineNodeSchedule)this).execute(), Instant.now(), Duration.parse("PT5S"));
    }

    public void close() {
    }

    @Generated
    public OfflineNodeSchedule(ServerNodeMapper serverNodeMapper) {
        this.serverNodeMapper = serverNodeMapper;
    }
}

