/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.binding;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.BindingContext;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.deps.org.objectweb.asm.tree.FieldNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;

public class FieldBinding
extends Binding {
    private Type owner;
    private boolean box = false;
    private String name;
    private boolean isStatic = false;
    private Type type;

    public FieldBinding(Type owner, String name, Type type, boolean isStatic, boolean box) {
        this.owner = owner;
        this.name = name;
        this.isStatic = isStatic;
        this.box = box;
        this.type = type;
    }

    @Override
    public void pushOntoStack(InsnList instructions, BindingContext bindingContext) {
        Type onwerType = this.owner;
        Type fieldType = this.type;
        boolean fieldIsStatic = this.isStatic;
        if (this.owner == null) {
            onwerType = Type.getObjectType((String)bindingContext.getMethodProcessor().getOwner());
        }
        MethodProcessor methodProcessor = bindingContext.getMethodProcessor();
        if (fieldType == null) {
            ClassNode classNode = methodProcessor.getClassNode();
            if (classNode == null) {
                throw new IllegalArgumentException("classNode is null, cann not get owner type. FieldBinding name:" + this.name);
            }
            FieldNode field = AsmUtils.findField(classNode.fields, this.name);
            if (field == null) {
                throw new IllegalArgumentException("can not find field in ClassNode. FieldBinding name:" + this.name);
            }
            fieldType = Type.getType((String)field.desc);
            fieldIsStatic = (field.access & 8) != 0;
        }
        if (fieldIsStatic) {
            AsmOpUtils.getStatic(instructions, onwerType, this.name, fieldType);
        } else {
            methodProcessor.loadThis(instructions);
            AsmOpUtils.getField(instructions, onwerType, this.name, fieldType);
        }
        if (this.box) {
            AsmOpUtils.box(instructions, fieldType);
        }
    }

    @Override
    public Type getType(BindingContext bindingContext) {
        Type fieldType = this.type;
        if (fieldType == null) {
            ClassNode classNode = bindingContext.getMethodProcessor().getClassNode();
            if (classNode == null) {
                throw new IllegalArgumentException("classNode is null, cann not get owner type. FieldBinding name:" + this.name);
            }
            FieldNode field = AsmUtils.findField(classNode.fields, this.name);
            if (field == null) {
                throw new IllegalArgumentException("can not find field in ClassNode. FieldBinding name:" + this.name);
            }
            fieldType = Type.getType((String)field.desc);
        }
        return fieldType;
    }
}

