/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.binding;

import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.BindingContext;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;
import java.util.List;

public class LocalVarsBinding
extends Binding {
    @Override
    public void pushOntoStack(InsnList instructions, BindingContext bindingContext) {
        AbstractInsnNode currentInsnNode = bindingContext.getLocation().getInsnNode();
        List<LocalVariableNode> results = AsmOpUtils.validVariables(bindingContext.getMethodProcessor().getMethodNode().localVariables, currentInsnNode);
        AsmOpUtils.push(instructions, results.size());
        AsmOpUtils.newArray(instructions, AsmOpUtils.OBJECT_TYPE);
        for (int i = 0; i < results.size(); ++i) {
            AsmOpUtils.dup(instructions);
            AsmOpUtils.push(instructions, i);
            LocalVariableNode variableNode = results.get(i);
            AsmOpUtils.loadVar(instructions, Type.getType((String)variableNode.desc), variableNode.index);
            AsmOpUtils.box(instructions, Type.getType((String)variableNode.desc));
            AsmOpUtils.arrayStore(instructions, AsmOpUtils.OBJECT_TYPE);
        }
    }

    @Override
    public Type getType(BindingContext bindingContext) {
        return AsmOpUtils.OBJECT_ARRAY_TYPE;
    }
}

