/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.converters.AutoConverter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.metadata.Holder;
import com.alibaba.excel.metadata.property.DateTimeFormatProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.FontProperty;
import com.alibaba.excel.metadata.property.NumberFormatProperty;
import com.alibaba.excel.metadata.property.StyleProperty;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.util.MapUtils;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanMap;

public class ClassUtils {
    public static final Map<Class<?>, FieldCache> FIELD_CACHE = new ConcurrentHashMap();
    public static final Map<Class<?>, Map<String, ExcelContentProperty>> CLASS_CONTENT_CACHE = new ConcurrentHashMap();
    public static final Map<ContentPropertyKey, ExcelContentProperty> CONTENT_CACHE = new ConcurrentHashMap<ContentPropertyKey, ExcelContentProperty>();

    public static ExcelContentProperty declaredExcelContentProperty(Map<?, ?> dataMap, Class<?> headClazz, String fieldName) {
        Object bean;
        Class<?> clazz = null;
        if (dataMap instanceof BeanMap && (bean = ((BeanMap)dataMap).getBean()) != null) {
            clazz = bean.getClass();
        }
        return ClassUtils.getExcelContentProperty(clazz, headClazz, fieldName);
    }

    private static ExcelContentProperty getExcelContentProperty(Class<?> clazz, Class<?> headClass, String fieldName) {
        return CONTENT_CACHE.computeIfAbsent(ClassUtils.buildKey(clazz, headClass, fieldName), key -> {
            ExcelContentProperty excelContentProperty = Optional.ofNullable(ClassUtils.declaredFieldContentMap(clazz)).map(map -> (ExcelContentProperty)map.get(fieldName)).orElse(null);
            ExcelContentProperty headExcelContentProperty = Optional.ofNullable(ClassUtils.declaredFieldContentMap(headClass)).map(map -> (ExcelContentProperty)map.get(fieldName)).orElse(null);
            ExcelContentProperty combineExcelContentProperty = new ExcelContentProperty();
            ClassUtils.combineExcelContentProperty(combineExcelContentProperty, headExcelContentProperty);
            if (clazz != headClass) {
                ClassUtils.combineExcelContentProperty(combineExcelContentProperty, excelContentProperty);
            }
            return combineExcelContentProperty;
        });
    }

    public static void combineExcelContentProperty(ExcelContentProperty combineExcelContentProperty, ExcelContentProperty excelContentProperty) {
        if (excelContentProperty == null) {
            return;
        }
        if (excelContentProperty.getField() != null) {
            combineExcelContentProperty.setField(excelContentProperty.getField());
        }
        if (excelContentProperty.getConverter() != null) {
            combineExcelContentProperty.setConverter(excelContentProperty.getConverter());
        }
        if (excelContentProperty.getDateTimeFormatProperty() != null) {
            combineExcelContentProperty.setDateTimeFormatProperty(excelContentProperty.getDateTimeFormatProperty());
        }
        if (excelContentProperty.getNumberFormatProperty() != null) {
            combineExcelContentProperty.setNumberFormatProperty(excelContentProperty.getNumberFormatProperty());
        }
        if (excelContentProperty.getContentStyleProperty() != null) {
            combineExcelContentProperty.setContentStyleProperty(excelContentProperty.getContentStyleProperty());
        }
        if (excelContentProperty.getContentFontProperty() != null) {
            combineExcelContentProperty.setContentFontProperty(excelContentProperty.getContentFontProperty());
        }
    }

    private static ContentPropertyKey buildKey(Class<?> clazz, Class<?> headClass, String fieldName) {
        return new ContentPropertyKey(clazz, headClass, fieldName);
    }

    private static Map<String, ExcelContentProperty> declaredFieldContentMap(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return CLASS_CONTENT_CACHE.computeIfAbsent(clazz, key -> {
            ArrayList tempFieldList = new ArrayList();
            for (Class tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
                Collections.addAll(tempFieldList, tempClass.getDeclaredFields());
            }
            ContentStyle parentContentStyle = clazz.getAnnotation(ContentStyle.class);
            ContentFontStyle parentContentFontStyle = clazz.getAnnotation(ContentFontStyle.class);
            HashMap<String, ExcelContentProperty> fieldContentMap = MapUtils.newHashMapWithExpectedSize(tempFieldList.size());
            for (Field field : tempFieldList) {
                ContentStyle contentStyle;
                Class<Converter<?>> convertClazz;
                ExcelContentProperty excelContentProperty = new ExcelContentProperty();
                excelContentProperty.setField(field);
                ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
                if (excelProperty != null && (convertClazz = excelProperty.converter()) != AutoConverter.class) {
                    try {
                        Converter<?> converter = convertClazz.newInstance();
                        excelContentProperty.setConverter(converter);
                    }
                    catch (Exception e) {
                        throw new ExcelCommonException("Can not instance custom converter:" + convertClazz.getName());
                    }
                }
                if ((contentStyle = field.getAnnotation(ContentStyle.class)) == null) {
                    contentStyle = parentContentStyle;
                }
                excelContentProperty.setContentStyleProperty(StyleProperty.build(contentStyle));
                ContentFontStyle contentFontStyle = field.getAnnotation(ContentFontStyle.class);
                if (contentFontStyle == null) {
                    contentFontStyle = parentContentFontStyle;
                }
                excelContentProperty.setContentFontProperty(FontProperty.build(contentFontStyle));
                excelContentProperty.setDateTimeFormatProperty(DateTimeFormatProperty.build(field.getAnnotation(DateTimeFormat.class)));
                excelContentProperty.setNumberFormatProperty(NumberFormatProperty.build(field.getAnnotation(NumberFormat.class)));
                fieldContentMap.put(field.getName(), excelContentProperty);
            }
            return fieldContentMap;
        });
    }

    public static void declaredFields(Class<?> clazz, Map<Integer, Field> sortedAllFiledMap, Map<Integer, Field> indexFiledMap, Map<String, Field> ignoreMap, Boolean needIgnore, Holder holder) {
        Map<Integer, Field> tempIndexFieldMap;
        FieldCache fieldCache = ClassUtils.declaredFields(clazz);
        if (fieldCache == null) {
            return;
        }
        if (ignoreMap != null) {
            ignoreMap.putAll(fieldCache.getIgnoreMap());
        }
        if ((tempIndexFieldMap = indexFiledMap) == null) {
            tempIndexFieldMap = MapUtils.newTreeMap();
        }
        tempIndexFieldMap.putAll(fieldCache.getIndexFiledMap());
        Map<Integer, Field> originSortedAllFiledMap = fieldCache.getSortedAllFiledMap();
        if (!needIgnore.booleanValue()) {
            sortedAllFiledMap.putAll(originSortedAllFiledMap);
            return;
        }
        int index = 0;
        for (Map.Entry<Integer, Field> entry : originSortedAllFiledMap.entrySet()) {
            Integer key = entry.getKey();
            Field field = entry.getValue();
            if (((WriteHolder)holder).ignore(entry.getValue().getName(), entry.getKey())) {
                if (ignoreMap != null) {
                    ignoreMap.put(field.getName(), field);
                }
                tempIndexFieldMap.remove(index);
                continue;
            }
            if (tempIndexFieldMap.containsKey(key)) {
                sortedAllFiledMap.put(key, field);
                continue;
            }
            while (sortedAllFiledMap.containsKey(index)) {
                ++index;
            }
            sortedAllFiledMap.put(index++, field);
        }
    }

    public static void declaredFields(Class<?> clazz, Map<Integer, Field> sortedAllFiledMap, Boolean needIgnore, WriteHolder writeHolder) {
        ClassUtils.declaredFields(clazz, sortedAllFiledMap, null, null, needIgnore, writeHolder);
    }

    private static FieldCache declaredFields(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return FIELD_CACHE.computeIfAbsent(clazz, key -> {
            ArrayList tempFieldList = new ArrayList();
            for (Class tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
                Collections.addAll(tempFieldList, tempClass.getDeclaredFields());
            }
            TreeMap<Integer, List<Field>> orderFiledMap = new TreeMap<Integer, List<Field>>();
            TreeMap<Integer, Field> indexFiledMap = new TreeMap<Integer, Field>();
            HashMap<String, Field> ignoreMap = new HashMap<String, Field>(16);
            ExcelIgnoreUnannotated excelIgnoreUnannotated = clazz.getAnnotation(ExcelIgnoreUnannotated.class);
            for (Field field : tempFieldList) {
                ClassUtils.declaredOneField(field, orderFiledMap, indexFiledMap, ignoreMap, excelIgnoreUnannotated);
            }
            return new FieldCache(ClassUtils.buildSortedAllFiledMap(orderFiledMap, indexFiledMap), indexFiledMap, ignoreMap);
        });
    }

    private static Map<Integer, Field> buildSortedAllFiledMap(Map<Integer, List<Field>> orderFiledMap, Map<Integer, Field> indexFiledMap) {
        HashMap<Integer, Field> sortedAllFiledMap = new HashMap<Integer, Field>((orderFiledMap.size() + indexFiledMap.size()) * 4 / 3 + 1);
        HashMap<Integer, Field> tempIndexFiledMap = new HashMap<Integer, Field>(indexFiledMap);
        int index = 0;
        for (List<Field> fieldList : orderFiledMap.values()) {
            for (Field field : fieldList) {
                while (tempIndexFiledMap.containsKey(index)) {
                    sortedAllFiledMap.put(index, (Field)tempIndexFiledMap.get(index));
                    tempIndexFiledMap.remove(index);
                    ++index;
                }
                sortedAllFiledMap.put(index, field);
                ++index;
            }
        }
        sortedAllFiledMap.putAll(tempIndexFiledMap);
        return sortedAllFiledMap;
    }

    private static void declaredOneField(Field field, Map<Integer, List<Field>> orderFiledMap, Map<Integer, Field> indexFiledMap, Map<String, Field> ignoreMap, ExcelIgnoreUnannotated excelIgnoreUnannotated) {
        boolean isStaticFinalOrTransient;
        boolean noExcelProperty;
        ExcelIgnore excelIgnore = field.getAnnotation(ExcelIgnore.class);
        if (excelIgnore != null) {
            ignoreMap.put(field.getName(), field);
            return;
        }
        ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
        boolean bl = noExcelProperty = excelProperty == null && excelIgnoreUnannotated != null;
        if (noExcelProperty) {
            ignoreMap.put(field.getName(), field);
            return;
        }
        boolean bl2 = isStaticFinalOrTransient = Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
        if (excelProperty == null && isStaticFinalOrTransient) {
            ignoreMap.put(field.getName(), field);
            return;
        }
        if (excelProperty != null && excelProperty.index() >= 0) {
            if (indexFiledMap.containsKey(excelProperty.index())) {
                throw new ExcelCommonException("The index of '" + indexFiledMap.get(excelProperty.index()).getName() + "' and '" + field.getName() + "' must be inconsistent");
            }
            indexFiledMap.put(excelProperty.index(), field);
            return;
        }
        int order = Integer.MAX_VALUE;
        if (excelProperty != null) {
            order = excelProperty.order();
        }
        List orderFiledList = orderFiledMap.computeIfAbsent(order, key -> ListUtils.newArrayList());
        orderFiledList.add(field);
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                ClassUtils.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static class ContentPropertyKey {
        private Class<?> clazz;
        private Class<?> headClass;
        private String fieldName;

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Class<?> getHeadClass() {
            return this.headClass;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setHeadClass(Class<?> headClass) {
            this.headClass = headClass;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentPropertyKey)) {
                return false;
            }
            ContentPropertyKey other = (ContentPropertyKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            Class<?> this$headClass = this.getHeadClass();
            Class<?> other$headClass = other.getHeadClass();
            if (this$headClass == null ? other$headClass != null : !this$headClass.equals(other$headClass)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentPropertyKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            Class<?> $headClass = this.getHeadClass();
            result = result * 59 + ($headClass == null ? 43 : $headClass.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            return result;
        }

        public ContentPropertyKey(Class<?> clazz, Class<?> headClass, String fieldName) {
            this.clazz = clazz;
            this.headClass = headClass;
            this.fieldName = fieldName;
        }
    }

    private static class FieldCache {
        private final Map<Integer, Field> sortedAllFiledMap;
        private final Map<Integer, Field> indexFiledMap;
        private final Map<String, Field> ignoreMap;

        public FieldCache(Map<Integer, Field> sortedAllFiledMap, Map<Integer, Field> indexFiledMap, Map<String, Field> ignoreMap) {
            this.sortedAllFiledMap = sortedAllFiledMap;
            this.indexFiledMap = indexFiledMap;
            this.ignoreMap = ignoreMap;
        }

        public Map<Integer, Field> getSortedAllFiledMap() {
            return this.sortedAllFiledMap;
        }

        public Map<Integer, Field> getIndexFiledMap() {
            return this.indexFiledMap;
        }

        public Map<String, Field> getIgnoreMap() {
            return this.ignoreMap;
        }
    }
}

