/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env;

import com.alibaba.nacos.client.env.AbstractPropertySource;
import com.alibaba.nacos.client.env.SourceType;
import java.util.Map;

class SystemEnvPropertySource
extends AbstractPropertySource {
    private final Map<String, String> env = System.getenv();

    SystemEnvPropertySource() {
    }

    @Override
    SourceType getType() {
        return SourceType.SYS;
    }

    @Override
    String getProperty(String key) {
        String upperCaseKey;
        String checkedKey = this.checkPropertyName(key);
        if (checkedKey == null && !(upperCaseKey = key.toUpperCase()).equals(key)) {
            checkedKey = this.checkPropertyName(upperCaseKey);
        }
        if (checkedKey == null) {
            return null;
        }
        return this.env.get(checkedKey);
    }

    private String checkPropertyName(String name) {
        if (this.containsKey(name)) {
            return name;
        }
        String noDotName = name.replace('.', '_');
        if (!name.equals(noDotName) && this.containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name.replace('-', '_');
        if (!name.equals(noHyphenName) && this.containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noDotNoHyphenName = noDotName.replace('-', '_');
        if (!noDotName.equals(noDotNoHyphenName) && this.containsKey(noDotNoHyphenName)) {
            return noDotNoHyphenName;
        }
        return null;
    }

    private boolean containsKey(String name) {
        return this.env.containsKey(name);
    }
}

