/*
 * Copyright 2015 Alibaba Group Holding Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.nls.client.protocol;

/**
 * OutputFormatEnum enum
 *
 * @author zhishen
 * @date 2018/06/11
 */
public enum OutputFormatEnum {
    /**
     * pcm
     */
    PCM("pcm", 1),
    /**
     * wav
     */
    WAV("wav", 2),
    /**
     * mp3
     */
    MP3("mp3", 3),
    /**
     * 8k 8bit alaw
     */
    ALAW("alaw", 4),
    /**
     * mp3
     */
    OPU("opu", 5);

    String name;
    int index;

    public String getName() {
        return name;
    }

    OutputFormatEnum(String name, int index) {
        this.name = name;
        this.index = index;
    }
}
