/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.harissurf;

import com.alibaba.simpleimage.analyze.ModifiableConst;
import com.alibaba.simpleimage.analyze.harissurf.GaussianConstants;
import com.alibaba.simpleimage.analyze.harissurf.ImageTransformUtils;
import com.alibaba.simpleimage.analyze.harissurf.IntegralImage;
import com.alibaba.simpleimage.analyze.harissurf.SURFInterestPoint;
import com.alibaba.simpleimage.analyze.harissurf.SURFInterestPointN;
import com.alibaba.simpleimage.analyze.harris.Corner;
import com.alibaba.simpleimage.analyze.harris.HarrisFast;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HarrisSurf {
    private IntegralImage mIntegralImage;
    private double sigma;
    private double k;
    int spacing;
    private int[][] input;
    private int width;
    private int height;
    private List<SURFInterestPoint> interestPoints;
    private static float[][] guassian81_25;
    List<SURFInterestPointN> globalNaturalKeypoints = null;

    public List<SURFInterestPoint> getInterestPoints() {
        return this.interestPoints;
    }

    public HarrisSurf(BufferedImage image) {
        this(image, 1.2, 0.06, 4);
    }

    public HarrisSurf(BufferedImage image, double sigma, double k, int spacing) {
        this.sigma = sigma;
        this.k = k;
        this.spacing = spacing;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.input = new int[this.width][this.height];
        for (int i = 0; i < this.width - 1; ++i) {
            for (int j = 0; j < this.height - 1; ++j) {
                this.input[i][j] = HarrisSurf.rgb2gray(image.getRGB(i, j));
            }
        }
        this.mIntegralImage = new IntegralImage(image);
        this.interestPoints = new ArrayList<SURFInterestPoint>();
    }

    public static void joinsFilter(Map<SURFInterestPoint, SURFInterestPoint> matchMap) {
        Integer kp1V;
        Map.Entry<SURFInterestPoint, SURFInterestPoint> e;
        Iterator<Map.Entry<SURFInterestPoint, SURFInterestPoint>> iter = matchMap.entrySet().iterator();
        HashMap<SURFInterestPoint, Integer> map = new HashMap<SURFInterestPoint, Integer>();
        while (iter.hasNext()) {
            e = iter.next();
            kp1V = (Integer)map.get(e.getKey());
            int lI = kp1V == null ? 0 : kp1V;
            map.put(e.getKey(), lI + 1);
            Integer kp2V = (Integer)map.get(e.getValue());
            int rI = kp2V == null ? 0 : kp2V;
            map.put(e.getValue(), rI + 1);
        }
        iter = matchMap.entrySet().iterator();
        while (iter.hasNext()) {
            e = iter.next();
            kp1V = (Integer)map.get(e.getKey());
            Integer kp2V = (Integer)map.get(e.getValue());
            if (kp1V <= 1 && kp2V <= 1) continue;
            iter.remove();
        }
    }

    public static void geometricFilter(Map<SURFInterestPoint, SURFInterestPoint> matchMap, int w, int h) {
        int idx;
        double r;
        SURFInterestPoint toPoint;
        SURFInterestPoint fromPoint;
        Map.Entry<SURFInterestPoint, SURFInterestPoint> entry;
        if (matchMap.size() <= 1) {
            return;
        }
        int arcStep = ModifiableConst.getSolpeArcStep();
        int[] ms = new int[90 / arcStep + 1];
        Iterator<Map.Entry<SURFInterestPoint, SURFInterestPoint>> iter = matchMap.entrySet().iterator();
        int max_vote_count = 0;
        long max_vote = 0L;
        while (iter.hasNext()) {
            entry = iter.next();
            fromPoint = entry.getKey();
            toPoint = entry.getValue();
            if ((double)Math.abs(toPoint.getOrientation() - fromPoint.getOrientation()) > 0.1) {
                iter.remove();
                continue;
            }
            r = Math.atan((toPoint.getY() + (float)h - fromPoint.getY()) / (toPoint.getX() + (float)w - fromPoint.getX())) * 360.0 / (Math.PI * 2);
            if (r < 0.0) {
                r += 90.0;
            }
            idx = (int)r / arcStep;
            ms[idx] = ms[idx] + 1;
            if (ms[idx] <= max_vote_count) continue;
            max_vote_count = ms[idx];
            max_vote = idx;
        }
        iter = matchMap.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            fromPoint = entry.getKey();
            toPoint = entry.getValue();
            r = Math.atan((toPoint.getY() + (float)h - fromPoint.getY()) / (toPoint.getX() + (float)w - fromPoint.getX())) * 360.0 / (Math.PI * 2);
            if (r < 0.0) {
                r += 90.0;
            }
            if ((long)(idx = (int)r / arcStep) == max_vote) continue;
            iter.remove();
        }
    }

    public List<Corner> detectInterestPoints() {
        HarrisFast hf = new HarrisFast(this.input, this.width, this.height, this.mIntegralImage);
        hf.filter(this.sigma, this.k, this.spacing);
        return hf.corners;
    }

    public void getDescriptions(List<Corner> corners, boolean brootsift) {
        for (Corner c : corners) {
            SURFInterestPoint sp = new SURFInterestPoint(c.getX(), c.getY(), 1.0f, (int)c.getH());
            this.getOrientation(sp);
            this.getMDescriptor(sp, true, brootsift);
            this.interestPoints.add(sp);
        }
    }

    private static int rgb2gray(int srgb) {
        int r = srgb >> 16 & 0xFF;
        int g = srgb >> 8 & 0xFF;
        int b = srgb & 0xFF;
        return (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
    }

    private void getOrientation(SURFInterestPoint input) {
        float scale = input.getScale();
        int s = Math.round(scale);
        int r = Math.round(input.getY());
        int c = Math.round(input.getX());
        ArrayList<Double> xHaarResponses = new ArrayList<Double>();
        ArrayList<Double> yHaarResponses = new ArrayList<Double>();
        ArrayList<Double> angles = new ArrayList<Double>();
        for (int i = -6; i <= 6; ++i) {
            for (int j = -6; j <= 6; ++j) {
                if (i * i + j * j >= 36) continue;
                double gauss = GaussianConstants.Gauss25[Math.abs(i)][Math.abs(j)];
                double xHaarResponse = gauss * (double)this.haarX(r + j * s, c + i * s, 4 * s);
                double yHaarResponse = gauss * (double)this.haarY(r + j * s, c + i * s, 4 * s);
                xHaarResponses.add(xHaarResponse);
                yHaarResponses.add(yHaarResponse);
                angles.add(HarrisSurf.getAngle(xHaarResponse, yHaarResponse));
            }
        }
        float sumX = 0.0f;
        float sumY = 0.0f;
        float max = 0.0f;
        float orientation = 0.0f;
        float ang1 = 0.0f;
        while ((double)ang1 < Math.PI * 2) {
            float ang2 = (float)((double)ang1 + 1.0471975511965976 > Math.PI * 2 ? (double)ang1 - 5.235987755982989 : (double)ang1 + 1.0471975511965976);
            sumY = 0.0f;
            sumX = 0.0f;
            for (int k = 0; k < angles.size(); ++k) {
                float ang = ((Double)angles.get(k)).floatValue();
                if (ang1 < ang2 && ang1 < ang && ang < ang2) {
                    sumX += ((Double)xHaarResponses.get(k)).floatValue();
                    sumY += ((Double)yHaarResponses.get(k)).floatValue();
                    continue;
                }
                if (!(ang2 < ang1) || !(ang > 0.0f && ang < ang2) && (!(ang > ang1) || !((double)ang < Math.PI * 2))) continue;
                sumX += ((Double)xHaarResponses.get(k)).floatValue();
                sumY += ((Double)yHaarResponses.get(k)).floatValue();
            }
            if (sumX * sumX + sumY * sumY > max) {
                max = sumX * sumX + sumY * sumY;
                orientation = (float)HarrisSurf.getAngle(sumX, sumY);
            }
            ang1 += 0.15f;
        }
        input.setOrientation(orientation);
    }

    private float haarX(int row, int column, int s) {
        return ImageTransformUtils.BoxIntegral(this.mIntegralImage, row - s / 2, column, s, s / 2) - 1.0f * ImageTransformUtils.BoxIntegral(this.mIntegralImage, row - s / 2, column - s / 2, s, s / 2);
    }

    private float haarY(int row, int column, int s) {
        return ImageTransformUtils.BoxIntegral(this.mIntegralImage, row, column - s / 2, s / 2, s) - 1.0f * ImageTransformUtils.BoxIntegral(this.mIntegralImage, row - s / 2, column - s / 2, s / 2, s);
    }

    private static double getAngle(double xHaarResponse, double yHaarResponse) {
        if (xHaarResponse >= 0.0 && yHaarResponse >= 0.0) {
            return Math.atan(yHaarResponse / xHaarResponse);
        }
        if (xHaarResponse < 0.0 && yHaarResponse >= 0.0) {
            return Math.PI - Math.atan(-yHaarResponse / xHaarResponse);
        }
        if (xHaarResponse < 0.0 && yHaarResponse < 0.0) {
            return Math.PI + Math.atan(yHaarResponse / xHaarResponse);
        }
        if (xHaarResponse >= 0.0 && yHaarResponse < 0.0) {
            return Math.PI * 2 - Math.atan(-yHaarResponse / xHaarResponse);
        }
        return 0.0;
    }

    private void getMDescriptor(SURFInterestPoint point, boolean upright, boolean brootsift) {
        int count = 0;
        float[] desc = new float[64];
        double gauss_s1 = 0.0;
        double gauss_s2 = 0.0;
        double rx = 0.0;
        double ry = 0.0;
        double rrx = 0.0;
        double rry = 0.0;
        double len = 0.0;
        int i = 0;
        int j = 0;
        float cx = -0.5f;
        float cy = 0.0f;
        double scale = point.getScale();
        int x = Math.round(point.getX());
        int y = Math.round(point.getY());
        for (i = -8; i < 12; i += 9) {
            i -= 4;
            cx += 1.0f;
            cy = -0.5f;
            for (j = -8; j < 12; j += 9) {
                double mdy = 0.0;
                double mdx = 0.0;
                double dy = 0.0;
                double dx = 0.0;
                cy += 1.0f;
                j -= 4;
                for (int k = i; k < i + 9; ++k) {
                    for (int l = j; l < j + 9; ++l) {
                        int sample_x = x + k;
                        int sample_y = y + l;
                        gauss_s1 = guassian81_25[Math.abs(k)][Math.abs(l)];
                        rx = this.haarX(sample_y, sample_x, (int)(2L * Math.round(scale)));
                        ry = this.haarY(sample_y, sample_x, (int)(2L * Math.round(scale)));
                        rrx = gauss_s1 * ry;
                        rry = gauss_s1 * rx;
                        dx += rrx;
                        dy += rry;
                        mdx += Math.abs(rrx);
                        mdy += Math.abs(rry);
                    }
                }
                gauss_s2 = HarrisSurf.gaussian(cx - 2.0f, cy - 2.0f, 1.5);
                desc[count++] = (float)(dx * gauss_s2);
                desc[count++] = (float)(dy * gauss_s2);
                desc[count++] = (float)(mdx * gauss_s2);
                desc[count++] = (float)(mdy * gauss_s2);
                len += (dx * dx + dy * dy + mdx * mdx + mdy * mdy) * (gauss_s2 * gauss_s2);
            }
        }
        len = Math.sqrt(len);
        i = 0;
        while (i < desc.length) {
            int n = i++;
            desc[n] = (float)((double)desc[n] / len);
        }
        if (brootsift) {
            float sum = 0.0f;
            for (float f : desc) {
                sum += Math.abs(f);
            }
            for (i = 0; i < desc.length; ++i) {
                desc[i] = desc[i] < 0.0f ? (float)(-Math.sqrt(-desc[i] / sum)) : (float)Math.sqrt(desc[i] / sum);
            }
        }
        point.setDescriptor(desc);
    }

    private static double gaussian(double x, double y, double sig) {
        return 1.0 / (Math.PI * 2 * sig * sig) * Math.exp(-(x * x + y * y) / (2.0 * sig * sig));
    }

    public static Map<SURFInterestPoint, SURFInterestPoint> match(List<SURFInterestPoint> src, List<SURFInterestPoint> dest) {
        HashMap<SURFInterestPoint, SURFInterestPoint> matchMap = new HashMap<SURFInterestPoint, SURFInterestPoint>(src.size() * 14 / 10);
        for (SURFInterestPoint sp : src) {
            float min_dist = Float.MAX_VALUE;
            SURFInterestPoint min_sp = null;
            block1: for (SURFInterestPoint sp2 : dest) {
                float sum = 0.0f;
                float[] location = sp2.getLocation();
                float[] mDescriptor = sp.getLocation();
                if (location == null || mDescriptor == null) continue;
                for (int i = 0; i < mDescriptor.length; ++i) {
                    float diff = mDescriptor[i] - location[i];
                    if ((sum += diff * diff) >= min_dist) continue block1;
                }
                min_dist = sum;
                min_sp = sp2;
            }
            matchMap.put(sp, min_sp);
        }
        return matchMap;
    }

    public List<SURFInterestPointN> getGlobalNaturalInterestPoints() {
        if (this.globalNaturalKeypoints != null) {
            return this.globalNaturalKeypoints;
        }
        if (this.interestPoints == null) {
            throw new IllegalArgumentException("No interestPoints generated yet.");
        }
        this.globalNaturalKeypoints = new ArrayList<SURFInterestPointN>();
        for (SURFInterestPoint sp : this.interestPoints) {
            this.globalNaturalKeypoints.add(new SURFInterestPointN(sp));
        }
        return this.globalNaturalKeypoints;
    }

    static {
        int radius = 13;
        guassian81_25 = new float[radius][radius];
        for (int j = 0; j < radius; ++j) {
            for (int i = 0; i < radius; ++i) {
                HarrisSurf.guassian81_25[i][j] = (float)HarrisSurf.gaussian(i, j, 2.5);
            }
        }
    }
}

