/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.cluster.impl;

import com.alibaba.simpleimage.analyze.search.cluster.ClusterChecker;
import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import com.alibaba.simpleimage.analyze.search.cluster.impl.Cluster;
import com.alibaba.simpleimage.analyze.search.util.ClusterUtils;

public class DriftClusterChecker
implements ClusterChecker {
    private float mDriftTolerance;

    public DriftClusterChecker(float driftTolerance) {
        this.mDriftTolerance = driftTolerance;
    }

    public boolean recalculateClusters(Clusterable[] clusters) {
        for (Clusterable cluster : clusters) {
            float distanceChange;
            if (!(cluster instanceof Cluster) || ((Cluster)cluster).getItems().size() <= 0 || !((distanceChange = ClusterUtils.getEuclideanDistance(((Cluster)cluster).getClusterMean(), cluster.getLocation())) > this.mDriftTolerance)) continue;
            return true;
        }
        return false;
    }
}

