/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.jai.cmm;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;

public class CMMColorSpace
extends ICC_ColorSpace {
    private static final long serialVersionUID = -6155748576908535877L;
    private static ColorSpace CMYspace;
    private static ColorSpace CMYKspace;
    private static final String CMY_PROFILE_NAME = "CMY.pf";
    private static final String CMYK_PROFILE_NAME = "RSWOP.ICM";

    private CMMColorSpace(ICC_Profile profile) {
        super(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColorSpace getInstance(int colorspace) {
        ColorSpace theColorSpace = null;
        switch (colorspace) {
            case 11: {
                Class<ColorSpace> clazz = ColorSpace.class;
                synchronized (ColorSpace.class) {
                    if (CMYspace != null) return CMYspace;
                    ICC_Profile theProfile = CMMColorSpace.getICC_Profile(CMY_PROFILE_NAME);
                    CMYspace = new ICC_ColorSpace(theProfile);
                    return CMYspace;
                }
            }
            case 9: {
                Class<ColorSpace> clazz = ColorSpace.class;
                synchronized (ColorSpace.class) {
                    if (CMYKspace != null) return CMYKspace;
                    ICC_Profile theProfile = CMMColorSpace.getICC_Profile(CMYK_PROFILE_NAME);
                    CMYKspace = new ICC_ColorSpace(theProfile);
                    return CMYKspace;
                }
            }
            case 5: {
                return ColorSpace.getInstance(1000);
            }
            case 6: {
                return ColorSpace.getInstance(1003);
            }
            default: {
                throw new IllegalArgumentException("Unknown ColorSpace " + colorspace);
            }
        }
    }

    public static ICC_Profile getICC_Profile(String name) {
        InputStream is = CMMColorSpace.class.getResourceAsStream("/META-INF/simpleimage/cmm/" + name);
        try {
            ICC_Profile iccp;
            ICC_Profile iCC_Profile = iccp = ICC_Profile.getInstance(is);
            return iCC_Profile;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid icc profile");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

