/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.ImageRender;
import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.render.DrawTextParameter;
import com.alibaba.simpleimage.render.ReadRender;
import com.alibaba.simpleimage.util.ImageDrawHelper;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DrawTextRender
extends ImageRender {
    private DrawTextParameter drawTextParameter = null;
    private ImageWrapper imgWrapper = null;

    public DrawTextRender(ImageRender imageRender, DrawTextParameter param) {
        super(imageRender);
        this.drawTextParameter = param;
    }

    public DrawTextRender(ImageWrapper imgWrapper, DrawTextParameter param) {
        super(null);
        this.drawTextParameter = param;
        this.imgWrapper = imgWrapper;
    }

    public DrawTextRender(InputStream input, DrawTextParameter param) {
        super(new ReadRender(input));
        this.drawTextParameter = param;
    }

    public DrawTextRender(InputStream input, boolean tosRGBColorSpace, DrawTextParameter param) {
        super(new ReadRender(input, tosRGBColorSpace));
        this.drawTextParameter = param;
    }

    public void dispose() throws SimpleImageException {
        super.dispose();
        this.drawTextParameter = null;
    }

    public ImageWrapper render() throws SimpleImageException {
        if (this.drawTextParameter == null || this.drawTextParameter.getTextInfo() == null || this.drawTextParameter.getTextInfo().size() == 0) {
            if (this.imgWrapper == null) {
                return this.imageRender.render();
            }
            return this.imgWrapper;
        }
        if (this.imgWrapper == null) {
            this.imgWrapper = this.imageRender.render();
        }
        for (int i = 0; i < this.imgWrapper.getNumOfImages(); ++i) {
            BufferedImage bi = this.imgWrapper.getAsBufferedImage(i);
            ImageDrawHelper.drawText(bi, this.drawTextParameter);
            this.imgWrapper.setImage(i, bi);
        }
        return this.imgWrapper;
    }

    public DrawTextParameter getDrawTextParameter() {
        return this.drawTextParameter;
    }

    public void setDrawTextParameter(DrawTextParameter drawTextParameter) {
        this.drawTextParameter = drawTextParameter;
    }
}

