/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import com.alibaba.simpleimage.ImageFormat;
import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.codec.jpeg.JPEGDecoder;
import com.alibaba.simpleimage.io.ByteArraySeekableStreamWrap;
import com.alibaba.simpleimage.io.ImageBitsInputStream;
import com.alibaba.simpleimage.util.ImageLog;
import com.alibaba.simpleimage.util.ImageUtils;
import com.alibaba.simpleimage.util.JAIRegisterHelper;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.w3c.dom.Node;

public class ImageReadHelper {
    public static final int DEFAULT_HIGHT_QUALITY = 93;
    protected static ImageLog log;

    public static ImageWrapper read(InputStream input) throws SimpleImageException {
        try {
            input = ImageUtils.createMemoryStream(input);
            if (ImageUtils.isJPEG(input)) {
                return ImageReadHelper.readJPEG(input);
            }
            if (ImageUtils.isGIF(input)) {
                return ImageReadHelper.readGIF(input);
            }
            return ImageReadHelper.readGeneral(input);
        }
        catch (Exception e) {
            throw new SimpleImageException(e);
        }
    }

    public static ImageWrapper readJPEG(InputStream input) throws SimpleImageException {
        ImageWrapper img = null;
        ImageBitsInputStream imageStream = null;
        try {
            imageStream = new ImageBitsInputStream(input);
            JPEGDecoder decoder = new JPEGDecoder(imageStream);
            img = decoder.decode();
        }
        catch (Exception e) {
            throw new SimpleImageException(e);
        }
        return img;
    }

    public static ImageWrapper readGIF(InputStream input) throws SimpleImageException {
        ImageInputStream imageIn = null;
        ImageReader reader = null;
        try {
            imageIn = ImageIO.createImageInputStream(input);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageIn);
            if (!readers.hasNext()) {
                throw new IllegalStateException("No GIF reader matched");
            }
            reader = readers.next();
            reader.setInput(imageIn);
            int numOfImages = reader.getNumImages(true);
            if (numOfImages <= 0) {
                throw new SimpleImageException("a GIF without pictures inside, maybe it's a attack");
            }
            BufferedImage[] images = new BufferedImage[numOfImages];
            Node[] metadatas = new Node[numOfImages];
            IIOMetadata streamMetadata = reader.getStreamMetadata();
            for (int i = 0; i < numOfImages; ++i) {
                images[i] = reader.read(i);
                metadatas[i] = reader.getImageMetadata(i).getAsTree("javax_imageio_gif_image_1.0");
            }
            ImageWrapper img = new ImageWrapper(images);
            img.setImageFormat(ImageFormat.GIF);
            img.setStreamMetadata(streamMetadata.getAsTree("javax_imageio_gif_stream_1.0"));
            img.setMetadatas(metadatas);
            ImageWrapper imageWrapper = img;
            return imageWrapper;
        }
        catch (Exception e) {
            throw new SimpleImageException(e);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    public static ImageWrapper readGeneral(InputStream input) throws SimpleImageException {
        try {
            ImageWrapper img = null;
            ImageFormat format = ImageUtils.identifyFormat(input);
            if (format == null) {
                throw new IllegalArgumentException("Unsupported image format, only JPEG, GIF, PNG, BMP and TIFF are supported");
            }
            ByteArraySeekableStreamWrap wrap = null;
            wrap = ByteArraySeekableStreamWrap.wrapInputStream(input);
            ParameterBlock pb = new ParameterBlock();
            pb.add((Object)wrap);
            RenderedOp src = JAI.create((String)"Stream", (ParameterBlock)pb);
            img = new ImageWrapper((PlanarImage)src, 93);
            img.setImageFormat(format);
            return img;
        }
        catch (Exception e) {
            throw new SimpleImageException(e);
        }
    }

    static {
        JAIRegisterHelper.register();
        log = ImageLog.getLog(ImageReadHelper.class);
    }
}

