/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreatePrefixListRequest
extends Request {
    @Host
    @NameInMap(value="SourceRegionId")
    private String sourceRegionId;
    @Query
    @NameInMap(value="AddressFamily")
    @Validation(required=true)
    private String addressFamily;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Entry")
    private List<Entry> entry;
    @Query
    @NameInMap(value="MaxEntries")
    @Validation(required=true, maximum=200.0, minimum=1.0)
    private Integer maxEntries;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PrefixListName")
    @Validation(required=true)
    private String prefixListName;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;

    private CreatePrefixListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.sourceRegionId = builder.sourceRegionId;
        this.addressFamily = builder.addressFamily;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.entry = builder.entry;
        this.maxEntries = builder.maxEntries;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.prefixListName = builder.prefixListName;
        this.regionId = builder.regionId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreatePrefixListRequest create() {
        return CreatePrefixListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getSourceRegionId() {
        return this.sourceRegionId;
    }

    public String getAddressFamily() {
        return this.addressFamily;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Entry> getEntry() {
        return this.entry;
    }

    public Integer getMaxEntries() {
        return this.maxEntries;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getPrefixListName() {
        return this.prefixListName;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public static class Entry
    extends TeaModel {
        @NameInMap(value="Cidr")
        @Validation(required=true)
        private String cidr;
        @NameInMap(value="Description")
        private String description;

        private Entry(Builder builder) {
            this.cidr = builder.cidr;
            this.description = builder.description;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Entry create() {
            return Entry.builder().build();
        }

        public String getCidr() {
            return this.cidr;
        }

        public String getDescription() {
            return this.description;
        }

        public static final class Builder {
            private String cidr;
            private String description;

            public Builder cidr(String cidr) {
                this.cidr = cidr;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Entry build() {
                return new Entry(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreatePrefixListRequest, Builder> {
        private String sourceRegionId;
        private String addressFamily;
        private String clientToken;
        private String description;
        private List<Entry> entry;
        private Integer maxEntries;
        private String ownerAccount;
        private Long ownerId;
        private String prefixListName;
        private String regionId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;

        private Builder() {
        }

        private Builder(CreatePrefixListRequest request) {
            super((Request)request);
            this.sourceRegionId = request.sourceRegionId;
            this.addressFamily = request.addressFamily;
            this.clientToken = request.clientToken;
            this.description = request.description;
            this.entry = request.entry;
            this.maxEntries = request.maxEntries;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.prefixListName = request.prefixListName;
            this.regionId = request.regionId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
        }

        public Builder sourceRegionId(String sourceRegionId) {
            this.putHostParameter("SourceRegionId", sourceRegionId);
            this.sourceRegionId = sourceRegionId;
            return this;
        }

        public Builder addressFamily(String addressFamily) {
            this.putQueryParameter("AddressFamily", addressFamily);
            this.addressFamily = addressFamily;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder entry(List<Entry> entry) {
            this.putQueryParameter("Entry", entry);
            this.entry = entry;
            return this;
        }

        public Builder maxEntries(Integer maxEntries) {
            this.putQueryParameter("MaxEntries", maxEntries);
            this.maxEntries = maxEntries;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder prefixListName(String prefixListName) {
            this.putQueryParameter("PrefixListName", prefixListName);
            this.prefixListName = prefixListName;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public CreatePrefixListRequest build() {
            return new CreatePrefixListRequest(this);
        }
    }
}

