/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateStorageSetRequest
extends Request {
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="MaxPartitionNumber")
    private Integer maxPartitionNumber;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="StorageSetName")
    private String storageSetName;
    @Query
    @NameInMap(value="ZoneId")
    @Validation(required=true)
    private String zoneId;

    private CreateStorageSetRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.maxPartitionNumber = builder.maxPartitionNumber;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.storageSetName = builder.storageSetName;
        this.zoneId = builder.zoneId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateStorageSetRequest create() {
        return CreateStorageSetRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getMaxPartitionNumber() {
        return this.maxPartitionNumber;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getStorageSetName() {
        return this.storageSetName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public static final class Builder
    extends Request.Builder<CreateStorageSetRequest, Builder> {
        private String clientToken;
        private String description;
        private Integer maxPartitionNumber;
        private String ownerAccount;
        private Long ownerId;
        private String regionId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String storageSetName;
        private String zoneId;

        private Builder() {
        }

        private Builder(CreateStorageSetRequest request) {
            super((Request)request);
            this.clientToken = request.clientToken;
            this.description = request.description;
            this.maxPartitionNumber = request.maxPartitionNumber;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.storageSetName = request.storageSetName;
            this.zoneId = request.zoneId;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder maxPartitionNumber(Integer maxPartitionNumber) {
            this.putQueryParameter("MaxPartitionNumber", maxPartitionNumber);
            this.maxPartitionNumber = maxPartitionNumber;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder storageSetName(String storageSetName) {
            this.putQueryParameter("StorageSetName", storageSetName);
            this.storageSetName = storageSetName;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.putQueryParameter("ZoneId", zoneId);
            this.zoneId = zoneId;
            return this;
        }

        public CreateStorageSetRequest build() {
            return new CreateStorageSetRequest(this);
        }
    }
}

