/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class DescribeDiagnosticMetricSetsRequest
extends Request {
    @Query
    @NameInMap(value="MaxResults")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer maxResults;
    @Query
    @NameInMap(value="MetricSetIds")
    private List<String> metricSetIds;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceType")
    private String resourceType;
    @Query
    @NameInMap(value="Type")
    private String type;

    private DescribeDiagnosticMetricSetsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.maxResults = builder.maxResults;
        this.metricSetIds = builder.metricSetIds;
        this.nextToken = builder.nextToken;
        this.regionId = builder.regionId;
        this.resourceType = builder.resourceType;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDiagnosticMetricSetsRequest create() {
        return DescribeDiagnosticMetricSetsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public List<String> getMetricSetIds() {
        return this.metricSetIds;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<DescribeDiagnosticMetricSetsRequest, Builder> {
        private Integer maxResults;
        private List<String> metricSetIds;
        private String nextToken;
        private String regionId;
        private String resourceType;
        private String type;

        private Builder() {
        }

        private Builder(DescribeDiagnosticMetricSetsRequest request) {
            super((Request)request);
            this.maxResults = request.maxResults;
            this.metricSetIds = request.metricSetIds;
            this.nextToken = request.nextToken;
            this.regionId = request.regionId;
            this.resourceType = request.resourceType;
            this.type = request.type;
        }

        public Builder maxResults(Integer maxResults) {
            this.putQueryParameter("MaxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder metricSetIds(List<String> metricSetIds) {
            this.putQueryParameter("MetricSetIds", metricSetIds);
            this.metricSetIds = metricSetIds;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public DescribeDiagnosticMetricSetsRequest build() {
            return new DescribeDiagnosticMetricSetsRequest(this);
        }
    }
}

