/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class DescribeDiagnosticMetricsRequest
extends Request {
    @Host
    @NameInMap(value="body")
    private String body;
    @Query
    @NameInMap(value="MaxResults")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer maxResults;
    @Query
    @NameInMap(value="MetricIds")
    private List<String> metricIds;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceType")
    private String resourceType;

    private DescribeDiagnosticMetricsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.body = builder.body;
        this.maxResults = builder.maxResults;
        this.metricIds = builder.metricIds;
        this.nextToken = builder.nextToken;
        this.regionId = builder.regionId;
        this.resourceType = builder.resourceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDiagnosticMetricsRequest create() {
        return DescribeDiagnosticMetricsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBody() {
        return this.body;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public List<String> getMetricIds() {
        return this.metricIds;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public static final class Builder
    extends Request.Builder<DescribeDiagnosticMetricsRequest, Builder> {
        private String body;
        private Integer maxResults;
        private List<String> metricIds;
        private String nextToken;
        private String regionId;
        private String resourceType;

        private Builder() {
        }

        private Builder(DescribeDiagnosticMetricsRequest request) {
            super((Request)request);
            this.body = request.body;
            this.maxResults = request.maxResults;
            this.metricIds = request.metricIds;
            this.nextToken = request.nextToken;
            this.regionId = request.regionId;
            this.resourceType = request.resourceType;
        }

        public Builder body(String body) {
            this.putHostParameter("body", body);
            this.body = body;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.putQueryParameter("MaxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder metricIds(List<String> metricIds) {
            this.putQueryParameter("MetricIds", metricIds);
            this.metricIds = metricIds;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public DescribeDiagnosticMetricsRequest build() {
            return new DescribeDiagnosticMetricsRequest(this);
        }
    }
}

