/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class DescribeDiagnosticReportsRequest
extends Request {
    @Host
    @NameInMap(value="SourceRegionId")
    private String sourceRegionId;
    @Query
    @NameInMap(value="MaxResults")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer maxResults;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ReportIds")
    private List<String> reportIds;
    @Query
    @NameInMap(value="ResourceIds")
    private List<String> resourceIds;
    @Query
    @NameInMap(value="Severity")
    private String severity;
    @Query
    @NameInMap(value="Status")
    private String status;

    private DescribeDiagnosticReportsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.sourceRegionId = builder.sourceRegionId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.regionId = builder.regionId;
        this.reportIds = builder.reportIds;
        this.resourceIds = builder.resourceIds;
        this.severity = builder.severity;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDiagnosticReportsRequest create() {
        return DescribeDiagnosticReportsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getSourceRegionId() {
        return this.sourceRegionId;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public List<String> getReportIds() {
        return this.reportIds;
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getStatus() {
        return this.status;
    }

    public static final class Builder
    extends Request.Builder<DescribeDiagnosticReportsRequest, Builder> {
        private String sourceRegionId;
        private Integer maxResults;
        private String nextToken;
        private String regionId;
        private List<String> reportIds;
        private List<String> resourceIds;
        private String severity;
        private String status;

        private Builder() {
        }

        private Builder(DescribeDiagnosticReportsRequest request) {
            super((Request)request);
            this.sourceRegionId = request.sourceRegionId;
            this.maxResults = request.maxResults;
            this.nextToken = request.nextToken;
            this.regionId = request.regionId;
            this.reportIds = request.reportIds;
            this.resourceIds = request.resourceIds;
            this.severity = request.severity;
            this.status = request.status;
        }

        public Builder sourceRegionId(String sourceRegionId) {
            this.putHostParameter("SourceRegionId", sourceRegionId);
            this.sourceRegionId = sourceRegionId;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.putQueryParameter("MaxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder reportIds(List<String> reportIds) {
            this.putQueryParameter("ReportIds", reportIds);
            this.reportIds = reportIds;
            return this;
        }

        public Builder resourceIds(List<String> resourceIds) {
            this.putQueryParameter("ResourceIds", resourceIds);
            this.resourceIds = resourceIds;
            return this;
        }

        public Builder severity(String severity) {
            this.putQueryParameter("Severity", severity);
            this.severity = severity;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public DescribeDiagnosticReportsRequest build() {
            return new DescribeDiagnosticReportsRequest(this);
        }
    }
}

