/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeHpcClustersRequest
extends Request {
    @Host
    @NameInMap(value="SourceRegionId")
    private String sourceRegionId;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="HpcClusterIds")
    private String hpcClusterIds;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;

    private DescribeHpcClustersRequest(Builder builder) {
        super((Request.Builder)builder);
        this.sourceRegionId = builder.sourceRegionId;
        this.clientToken = builder.clientToken;
        this.hpcClusterIds = builder.hpcClusterIds;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeHpcClustersRequest create() {
        return DescribeHpcClustersRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getSourceRegionId() {
        return this.sourceRegionId;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getHpcClusterIds() {
        return this.hpcClusterIds;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public static final class Builder
    extends Request.Builder<DescribeHpcClustersRequest, Builder> {
        private String sourceRegionId;
        private String clientToken;
        private String hpcClusterIds;
        private String ownerAccount;
        private Long ownerId;
        private Integer pageNumber;
        private Integer pageSize;
        private String regionId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;

        private Builder() {
        }

        private Builder(DescribeHpcClustersRequest request) {
            super((Request)request);
            this.sourceRegionId = request.sourceRegionId;
            this.clientToken = request.clientToken;
            this.hpcClusterIds = request.hpcClusterIds;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
        }

        public Builder sourceRegionId(String sourceRegionId) {
            this.putHostParameter("SourceRegionId", sourceRegionId);
            this.sourceRegionId = sourceRegionId;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder hpcClusterIds(String hpcClusterIds) {
            this.putQueryParameter("HpcClusterIds", hpcClusterIds);
            this.hpcClusterIds = hpcClusterIds;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public DescribeHpcClustersRequest build() {
            return new DescribeHpcClustersRequest(this);
        }
    }
}

