/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class DescribeReservedInstancesRequest
extends Request {
    @Query
    @NameInMap(value="AllocationType")
    private String allocationType;
    @Query
    @NameInMap(value="InstanceType")
    private String instanceType;
    @Query
    @NameInMap(value="InstanceTypeFamily")
    private String instanceTypeFamily;
    @Query
    @NameInMap(value="LockReason")
    private String lockReason;
    @Query
    @NameInMap(value="OfferingType")
    private String offeringType;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ReservedInstanceId")
    private List<String> reservedInstanceId;
    @Query
    @NameInMap(value="ReservedInstanceName")
    private String reservedInstanceName;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="Scope")
    private String scope;
    @Query
    @NameInMap(value="Status")
    private List<String> status;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;
    @Query
    @NameInMap(value="ZoneId")
    private String zoneId;

    private DescribeReservedInstancesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.allocationType = builder.allocationType;
        this.instanceType = builder.instanceType;
        this.instanceTypeFamily = builder.instanceTypeFamily;
        this.lockReason = builder.lockReason;
        this.offeringType = builder.offeringType;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.reservedInstanceId = builder.reservedInstanceId;
        this.reservedInstanceName = builder.reservedInstanceName;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.scope = builder.scope;
        this.status = builder.status;
        this.tag = builder.tag;
        this.zoneId = builder.zoneId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeReservedInstancesRequest create() {
        return DescribeReservedInstancesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAllocationType() {
        return this.allocationType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getInstanceTypeFamily() {
        return this.instanceTypeFamily;
    }

    public String getLockReason() {
        return this.lockReason;
    }

    public String getOfferingType() {
        return this.offeringType;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public List<String> getReservedInstanceId() {
        return this.reservedInstanceId;
    }

    public String getReservedInstanceName() {
        return this.reservedInstanceName;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getScope() {
        return this.scope;
    }

    public List<String> getStatus() {
        return this.status;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<DescribeReservedInstancesRequest, Builder> {
        private String allocationType;
        private String instanceType;
        private String instanceTypeFamily;
        private String lockReason;
        private String offeringType;
        private String ownerAccount;
        private Long ownerId;
        private Integer pageNumber;
        private Integer pageSize;
        private String regionId;
        private List<String> reservedInstanceId;
        private String reservedInstanceName;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String scope;
        private List<String> status;
        private List<Tag> tag;
        private String zoneId;

        private Builder() {
        }

        private Builder(DescribeReservedInstancesRequest request) {
            super((Request)request);
            this.allocationType = request.allocationType;
            this.instanceType = request.instanceType;
            this.instanceTypeFamily = request.instanceTypeFamily;
            this.lockReason = request.lockReason;
            this.offeringType = request.offeringType;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.reservedInstanceId = request.reservedInstanceId;
            this.reservedInstanceName = request.reservedInstanceName;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.scope = request.scope;
            this.status = request.status;
            this.tag = request.tag;
            this.zoneId = request.zoneId;
        }

        public Builder allocationType(String allocationType) {
            this.putQueryParameter("AllocationType", allocationType);
            this.allocationType = allocationType;
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.putQueryParameter("InstanceType", instanceType);
            this.instanceType = instanceType;
            return this;
        }

        public Builder instanceTypeFamily(String instanceTypeFamily) {
            this.putQueryParameter("InstanceTypeFamily", instanceTypeFamily);
            this.instanceTypeFamily = instanceTypeFamily;
            return this;
        }

        public Builder lockReason(String lockReason) {
            this.putQueryParameter("LockReason", lockReason);
            this.lockReason = lockReason;
            return this;
        }

        public Builder offeringType(String offeringType) {
            this.putQueryParameter("OfferingType", offeringType);
            this.offeringType = offeringType;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder reservedInstanceId(List<String> reservedInstanceId) {
            this.putQueryParameter("ReservedInstanceId", reservedInstanceId);
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public Builder reservedInstanceName(String reservedInstanceName) {
            this.putQueryParameter("ReservedInstanceName", reservedInstanceName);
            this.reservedInstanceName = reservedInstanceName;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder scope(String scope) {
            this.putQueryParameter("Scope", scope);
            this.scope = scope;
            return this;
        }

        public Builder status(List<String> status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.putQueryParameter("ZoneId", zoneId);
            this.zoneId = zoneId;
            return this;
        }

        public DescribeReservedInstancesRequest build() {
            return new DescribeReservedInstancesRequest(this);
        }
    }
}

