/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class DescribeSecurityGroupsRequest
extends Request {
    @Host
    @NameInMap(value="SourceRegionId")
    private String sourceRegionId;
    @Query
    @NameInMap(value="DryRun")
    private Boolean dryRun;
    @Query
    @NameInMap(value="FuzzyQuery")
    private Boolean fuzzyQuery;
    @Query
    @NameInMap(value="IsQueryEcsCount")
    private Boolean isQueryEcsCount;
    @Query
    @NameInMap(value="MaxResults")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer maxResults;
    @Query
    @NameInMap(value="NetworkType")
    private String networkType;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="SecurityGroupId")
    private String securityGroupId;
    @Query
    @NameInMap(value="SecurityGroupIds")
    private String securityGroupIds;
    @Query
    @NameInMap(value="SecurityGroupName")
    private String securityGroupName;
    @Query
    @NameInMap(value="SecurityGroupType")
    private String securityGroupType;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;
    @Query
    @NameInMap(value="VpcId")
    private String vpcId;

    private DescribeSecurityGroupsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.sourceRegionId = builder.sourceRegionId;
        this.dryRun = builder.dryRun;
        this.fuzzyQuery = builder.fuzzyQuery;
        this.isQueryEcsCount = builder.isQueryEcsCount;
        this.maxResults = builder.maxResults;
        this.networkType = builder.networkType;
        this.nextToken = builder.nextToken;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.resourceGroupId = builder.resourceGroupId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.securityGroupId = builder.securityGroupId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroupName = builder.securityGroupName;
        this.securityGroupType = builder.securityGroupType;
        this.tag = builder.tag;
        this.vpcId = builder.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeSecurityGroupsRequest create() {
        return DescribeSecurityGroupsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getSourceRegionId() {
        return this.sourceRegionId;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public Boolean getFuzzyQuery() {
        return this.fuzzyQuery;
    }

    public Boolean getIsQueryEcsCount() {
        return this.isQueryEcsCount;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public String getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    public String getSecurityGroupType() {
        return this.securityGroupType;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<DescribeSecurityGroupsRequest, Builder> {
        private String sourceRegionId;
        private Boolean dryRun;
        private Boolean fuzzyQuery;
        private Boolean isQueryEcsCount;
        private Integer maxResults;
        private String networkType;
        private String nextToken;
        private String ownerAccount;
        private Long ownerId;
        private Integer pageNumber;
        private Integer pageSize;
        private String regionId;
        private String resourceGroupId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String securityGroupId;
        private String securityGroupIds;
        private String securityGroupName;
        private String securityGroupType;
        private List<Tag> tag;
        private String vpcId;

        private Builder() {
        }

        private Builder(DescribeSecurityGroupsRequest request) {
            super((Request)request);
            this.sourceRegionId = request.sourceRegionId;
            this.dryRun = request.dryRun;
            this.fuzzyQuery = request.fuzzyQuery;
            this.isQueryEcsCount = request.isQueryEcsCount;
            this.maxResults = request.maxResults;
            this.networkType = request.networkType;
            this.nextToken = request.nextToken;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.resourceGroupId = request.resourceGroupId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.securityGroupId = request.securityGroupId;
            this.securityGroupIds = request.securityGroupIds;
            this.securityGroupName = request.securityGroupName;
            this.securityGroupType = request.securityGroupType;
            this.tag = request.tag;
            this.vpcId = request.vpcId;
        }

        public Builder sourceRegionId(String sourceRegionId) {
            this.putHostParameter("SourceRegionId", sourceRegionId);
            this.sourceRegionId = sourceRegionId;
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.putQueryParameter("DryRun", dryRun);
            this.dryRun = dryRun;
            return this;
        }

        public Builder fuzzyQuery(Boolean fuzzyQuery) {
            this.putQueryParameter("FuzzyQuery", fuzzyQuery);
            this.fuzzyQuery = fuzzyQuery;
            return this;
        }

        public Builder isQueryEcsCount(Boolean isQueryEcsCount) {
            this.putQueryParameter("IsQueryEcsCount", isQueryEcsCount);
            this.isQueryEcsCount = isQueryEcsCount;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.putQueryParameter("MaxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder networkType(String networkType) {
            this.putQueryParameter("NetworkType", networkType);
            this.networkType = networkType;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder securityGroupId(String securityGroupId) {
            this.putQueryParameter("SecurityGroupId", securityGroupId);
            this.securityGroupId = securityGroupId;
            return this;
        }

        public Builder securityGroupIds(String securityGroupIds) {
            this.putQueryParameter("SecurityGroupIds", securityGroupIds);
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder securityGroupName(String securityGroupName) {
            this.putQueryParameter("SecurityGroupName", securityGroupName);
            this.securityGroupName = securityGroupName;
            return this;
        }

        public Builder securityGroupType(String securityGroupType) {
            this.putQueryParameter("SecurityGroupType", securityGroupType);
            this.securityGroupType = securityGroupType;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.putQueryParameter("VpcId", vpcId);
            this.vpcId = vpcId;
            return this;
        }

        public DescribeSecurityGroupsRequest build() {
            return new DescribeSecurityGroupsRequest(this);
        }
    }
}

