/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class DescribeSnapshotsRequest
extends Request {
    @Query
    @NameInMap(value="Filter")
    private List<Filter> filter;
    @Host
    @NameInMap(value="SourceRegionId")
    private String sourceRegionId;
    @Query
    @NameInMap(value="Category")
    private String category;
    @Query
    @NameInMap(value="DiskId")
    private String diskId;
    @Query
    @NameInMap(value="DryRun")
    private Boolean dryRun;
    @Query
    @NameInMap(value="Encrypted")
    private Boolean encrypted;
    @Query
    @NameInMap(value="InstanceId")
    private String instanceId;
    @Query
    @NameInMap(value="KMSKeyId")
    private String KMSKeyId;
    @Query
    @NameInMap(value="MaxResults")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer maxResults;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="SnapshotIds")
    private String snapshotIds;
    @Query
    @NameInMap(value="SnapshotLinkId")
    private String snapshotLinkId;
    @Query
    @NameInMap(value="SnapshotName")
    private String snapshotName;
    @Query
    @NameInMap(value="SnapshotType")
    private String snapshotType;
    @Query
    @NameInMap(value="SourceDiskType")
    private String sourceDiskType;
    @Query
    @NameInMap(value="Status")
    private String status;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;
    @Query
    @NameInMap(value="Usage")
    private String usage;

    private DescribeSnapshotsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.filter = builder.filter;
        this.sourceRegionId = builder.sourceRegionId;
        this.category = builder.category;
        this.diskId = builder.diskId;
        this.dryRun = builder.dryRun;
        this.encrypted = builder.encrypted;
        this.instanceId = builder.instanceId;
        this.KMSKeyId = builder.KMSKeyId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.resourceGroupId = builder.resourceGroupId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.snapshotIds = builder.snapshotIds;
        this.snapshotLinkId = builder.snapshotLinkId;
        this.snapshotName = builder.snapshotName;
        this.snapshotType = builder.snapshotType;
        this.sourceDiskType = builder.sourceDiskType;
        this.status = builder.status;
        this.tag = builder.tag;
        this.usage = builder.usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeSnapshotsRequest create() {
        return DescribeSnapshotsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Filter> getFilter() {
        return this.filter;
    }

    public String getSourceRegionId() {
        return this.sourceRegionId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDiskId() {
        return this.diskId;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getKMSKeyId() {
        return this.KMSKeyId;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getSnapshotIds() {
        return this.snapshotIds;
    }

    public String getSnapshotLinkId() {
        return this.snapshotLinkId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    public String getSourceDiskType() {
        return this.sourceDiskType;
    }

    public String getStatus() {
        return this.status;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public String getUsage() {
        return this.usage;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static class Filter
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Filter(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Filter create() {
            return Filter.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Filter build() {
                return new Filter(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<DescribeSnapshotsRequest, Builder> {
        private List<Filter> filter;
        private String sourceRegionId;
        private String category;
        private String diskId;
        private Boolean dryRun;
        private Boolean encrypted;
        private String instanceId;
        private String KMSKeyId;
        private Integer maxResults;
        private String nextToken;
        private String ownerAccount;
        private Long ownerId;
        private Integer pageNumber;
        private Integer pageSize;
        private String regionId;
        private String resourceGroupId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String snapshotIds;
        private String snapshotLinkId;
        private String snapshotName;
        private String snapshotType;
        private String sourceDiskType;
        private String status;
        private List<Tag> tag;
        private String usage;

        private Builder() {
        }

        private Builder(DescribeSnapshotsRequest request) {
            super((Request)request);
            this.filter = request.filter;
            this.sourceRegionId = request.sourceRegionId;
            this.category = request.category;
            this.diskId = request.diskId;
            this.dryRun = request.dryRun;
            this.encrypted = request.encrypted;
            this.instanceId = request.instanceId;
            this.KMSKeyId = request.KMSKeyId;
            this.maxResults = request.maxResults;
            this.nextToken = request.nextToken;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.resourceGroupId = request.resourceGroupId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.snapshotIds = request.snapshotIds;
            this.snapshotLinkId = request.snapshotLinkId;
            this.snapshotName = request.snapshotName;
            this.snapshotType = request.snapshotType;
            this.sourceDiskType = request.sourceDiskType;
            this.status = request.status;
            this.tag = request.tag;
            this.usage = request.usage;
        }

        public Builder filter(List<Filter> filter) {
            this.putQueryParameter("Filter", filter);
            this.filter = filter;
            return this;
        }

        public Builder sourceRegionId(String sourceRegionId) {
            this.putHostParameter("SourceRegionId", sourceRegionId);
            this.sourceRegionId = sourceRegionId;
            return this;
        }

        public Builder category(String category) {
            this.putQueryParameter("Category", category);
            this.category = category;
            return this;
        }

        public Builder diskId(String diskId) {
            this.putQueryParameter("DiskId", diskId);
            this.diskId = diskId;
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.putQueryParameter("DryRun", dryRun);
            this.dryRun = dryRun;
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.putQueryParameter("Encrypted", encrypted);
            this.encrypted = encrypted;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder KMSKeyId(String KMSKeyId) {
            this.putQueryParameter("KMSKeyId", KMSKeyId);
            this.KMSKeyId = KMSKeyId;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.putQueryParameter("MaxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder snapshotIds(String snapshotIds) {
            this.putQueryParameter("SnapshotIds", snapshotIds);
            this.snapshotIds = snapshotIds;
            return this;
        }

        public Builder snapshotLinkId(String snapshotLinkId) {
            this.putQueryParameter("SnapshotLinkId", snapshotLinkId);
            this.snapshotLinkId = snapshotLinkId;
            return this;
        }

        public Builder snapshotName(String snapshotName) {
            this.putQueryParameter("SnapshotName", snapshotName);
            this.snapshotName = snapshotName;
            return this;
        }

        public Builder snapshotType(String snapshotType) {
            this.putQueryParameter("SnapshotType", snapshotType);
            this.snapshotType = snapshotType;
            return this;
        }

        public Builder sourceDiskType(String sourceDiskType) {
            this.putQueryParameter("SourceDiskType", sourceDiskType);
            this.sourceDiskType = sourceDiskType;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public Builder usage(String usage) {
            this.putQueryParameter("Usage", usage);
            this.usage = usage;
            return this;
        }

        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }
    }
}

