/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class DescribeStorageCapacityUnitsRequest
extends Request {
    @Query
    @NameInMap(value="AllocationType")
    private String allocationType;
    @Query
    @NameInMap(value="Capacity")
    private Integer capacity;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="Status")
    private List<String> status;
    @Query
    @NameInMap(value="StorageCapacityUnitId")
    private List<String> storageCapacityUnitId;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;

    private DescribeStorageCapacityUnitsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.allocationType = builder.allocationType;
        this.capacity = builder.capacity;
        this.name = builder.name;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.status = builder.status;
        this.storageCapacityUnitId = builder.storageCapacityUnitId;
        this.tag = builder.tag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeStorageCapacityUnitsRequest create() {
        return DescribeStorageCapacityUnitsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAllocationType() {
        return this.allocationType;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public List<String> getStatus() {
        return this.status;
    }

    public List<String> getStorageCapacityUnitId() {
        return this.storageCapacityUnitId;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<DescribeStorageCapacityUnitsRequest, Builder> {
        private String allocationType;
        private Integer capacity;
        private String name;
        private String ownerAccount;
        private Long ownerId;
        private Integer pageNumber;
        private Integer pageSize;
        private String regionId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private List<String> status;
        private List<String> storageCapacityUnitId;
        private List<Tag> tag;

        private Builder() {
        }

        private Builder(DescribeStorageCapacityUnitsRequest request) {
            super((Request)request);
            this.allocationType = request.allocationType;
            this.capacity = request.capacity;
            this.name = request.name;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.status = request.status;
            this.storageCapacityUnitId = request.storageCapacityUnitId;
            this.tag = request.tag;
        }

        public Builder allocationType(String allocationType) {
            this.putQueryParameter("AllocationType", allocationType);
            this.allocationType = allocationType;
            return this;
        }

        public Builder capacity(Integer capacity) {
            this.putQueryParameter("Capacity", capacity);
            this.capacity = capacity;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder status(List<String> status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public Builder storageCapacityUnitId(List<String> storageCapacityUnitId) {
            this.putQueryParameter("StorageCapacityUnitId", storageCapacityUnitId);
            this.storageCapacityUnitId = storageCapacityUnitId;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public DescribeStorageCapacityUnitsRequest build() {
            return new DescribeStorageCapacityUnitsRequest(this);
        }
    }
}

