/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ExportSnapshotRequest
extends Request {
    @Query
    @NameInMap(value="OssBucket")
    @Validation(required=true)
    private String ossBucket;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="RoleName")
    private String roleName;
    @Query
    @NameInMap(value="SnapshotId")
    @Validation(required=true)
    private String snapshotId;

    private ExportSnapshotRequest(Builder builder) {
        super((Request.Builder)builder);
        this.ossBucket = builder.ossBucket;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.roleName = builder.roleName;
        this.snapshotId = builder.snapshotId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExportSnapshotRequest create() {
        return ExportSnapshotRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOssBucket() {
        return this.ossBucket;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public static final class Builder
    extends Request.Builder<ExportSnapshotRequest, Builder> {
        private String ossBucket;
        private Long ownerId;
        private String regionId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String roleName;
        private String snapshotId;

        private Builder() {
        }

        private Builder(ExportSnapshotRequest request) {
            super((Request)request);
            this.ossBucket = request.ossBucket;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.roleName = request.roleName;
            this.snapshotId = request.snapshotId;
        }

        public Builder ossBucket(String ossBucket) {
            this.putQueryParameter("OssBucket", ossBucket);
            this.ossBucket = ossBucket;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder roleName(String roleName) {
            this.putQueryParameter("RoleName", roleName);
            this.roleName = roleName;
            return this;
        }

        public Builder snapshotId(String snapshotId) {
            this.putQueryParameter("SnapshotId", snapshotId);
            this.snapshotId = snapshotId;
            return this;
        }

        public ExportSnapshotRequest build() {
            return new ExportSnapshotRequest(this);
        }
    }
}

