/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ModifyReservedInstancesRequest
extends Request {
    @Query
    @NameInMap(value="Configuration")
    private List<Configuration> configuration;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ReservedInstanceId")
    @Validation(required=true)
    private List<String> reservedInstanceId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;

    private ModifyReservedInstancesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.configuration = builder.configuration;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.reservedInstanceId = builder.reservedInstanceId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyReservedInstancesRequest create() {
        return ModifyReservedInstancesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Configuration> getConfiguration() {
        return this.configuration;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public List<String> getReservedInstanceId() {
        return this.reservedInstanceId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public static class Configuration
    extends TeaModel {
        @NameInMap(value="InstanceAmount")
        private Integer instanceAmount;
        @NameInMap(value="InstanceType")
        private String instanceType;
        @NameInMap(value="ReservedInstanceName")
        private String reservedInstanceName;
        @NameInMap(value="Scope")
        private String scope;
        @NameInMap(value="ZoneId")
        private String zoneId;

        private Configuration(Builder builder) {
            this.instanceAmount = builder.instanceAmount;
            this.instanceType = builder.instanceType;
            this.reservedInstanceName = builder.reservedInstanceName;
            this.scope = builder.scope;
            this.zoneId = builder.zoneId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Configuration create() {
            return Configuration.builder().build();
        }

        public Integer getInstanceAmount() {
            return this.instanceAmount;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public String getReservedInstanceName() {
            return this.reservedInstanceName;
        }

        public String getScope() {
            return this.scope;
        }

        public String getZoneId() {
            return this.zoneId;
        }

        public static final class Builder {
            private Integer instanceAmount;
            private String instanceType;
            private String reservedInstanceName;
            private String scope;
            private String zoneId;

            public Builder instanceAmount(Integer instanceAmount) {
                this.instanceAmount = instanceAmount;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder reservedInstanceName(String reservedInstanceName) {
                this.reservedInstanceName = reservedInstanceName;
                return this;
            }

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public Builder zoneId(String zoneId) {
                this.zoneId = zoneId;
                return this;
            }

            public Configuration build() {
                return new Configuration(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ModifyReservedInstancesRequest, Builder> {
        private List<Configuration> configuration;
        private String ownerAccount;
        private Long ownerId;
        private String regionId;
        private List<String> reservedInstanceId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;

        private Builder() {
        }

        private Builder(ModifyReservedInstancesRequest request) {
            super((Request)request);
            this.configuration = request.configuration;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.reservedInstanceId = request.reservedInstanceId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
        }

        public Builder configuration(List<Configuration> configuration) {
            this.putQueryParameter("Configuration", configuration);
            this.configuration = configuration;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder reservedInstanceId(List<String> reservedInstanceId) {
            this.putQueryParameter("ReservedInstanceId", reservedInstanceId);
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public ModifyReservedInstancesRequest build() {
            return new ModifyReservedInstancesRequest(this);
        }
    }
}

