/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class ReleaseCapacityReservationRequest
extends Request {
    @Query
    @NameInMap(value="PrivatePoolOptions")
    private PrivatePoolOptions privatePoolOptions;
    @Host
    @NameInMap(value="SourceRegionId")
    private String sourceRegionId;
    @Query
    @NameInMap(value="DryRun")
    private Boolean dryRun;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;

    private ReleaseCapacityReservationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.privatePoolOptions = builder.privatePoolOptions;
        this.sourceRegionId = builder.sourceRegionId;
        this.dryRun = builder.dryRun;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReleaseCapacityReservationRequest create() {
        return ReleaseCapacityReservationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public PrivatePoolOptions getPrivatePoolOptions() {
        return this.privatePoolOptions;
    }

    public String getSourceRegionId() {
        return this.sourceRegionId;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public static class PrivatePoolOptions
    extends TeaModel {
        @NameInMap(value="Id")
        @Validation(required=true)
        private String id;

        private PrivatePoolOptions(Builder builder) {
            this.id = builder.id;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static PrivatePoolOptions create() {
            return PrivatePoolOptions.builder().build();
        }

        public String getId() {
            return this.id;
        }

        public static final class Builder {
            private String id;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public PrivatePoolOptions build() {
                return new PrivatePoolOptions(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ReleaseCapacityReservationRequest, Builder> {
        private PrivatePoolOptions privatePoolOptions;
        private String sourceRegionId;
        private Boolean dryRun;
        private String ownerAccount;
        private Long ownerId;
        private String regionId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;

        private Builder() {
        }

        private Builder(ReleaseCapacityReservationRequest request) {
            super((Request)request);
            this.privatePoolOptions = request.privatePoolOptions;
            this.sourceRegionId = request.sourceRegionId;
            this.dryRun = request.dryRun;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
        }

        public Builder privatePoolOptions(PrivatePoolOptions privatePoolOptions) {
            this.putQueryParameter("PrivatePoolOptions", (Object)privatePoolOptions);
            this.privatePoolOptions = privatePoolOptions;
            return this;
        }

        public Builder sourceRegionId(String sourceRegionId) {
            this.putHostParameter("SourceRegionId", sourceRegionId);
            this.sourceRegionId = sourceRegionId;
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.putQueryParameter("DryRun", dryRun);
            this.dryRun = dryRun;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public ReleaseCapacityReservationRequest build() {
            return new ReleaseCapacityReservationRequest(this);
        }
    }
}

